/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.LabelItem;

public class StoreLabelCursor
implements Cursor<LabelItem>,
LabelItem {
    private long[] labels;
    private int index;
    private int currentLabel;
    private Consumer<StoreLabelCursor> instanceCache;

    public StoreLabelCursor(Consumer<StoreLabelCursor> instanceCache) {
        this.instanceCache = instanceCache;
    }

    public StoreLabelCursor init(long[] labels) {
        this.labels = labels;
        this.index = 0;
        return this;
    }

    public boolean next() {
        if (this.index < this.labels.length) {
            this.currentLabel = IoPrimitiveUtils.safeCastLongToInt(this.labels[this.index++]);
            return true;
        }
        return false;
    }

    public LabelItem get() {
        return this;
    }

    @Override
    public int getAsInt() {
        return this.currentLabel;
    }

    public void close() {
        this.instanceCache.accept(this);
    }
}

