/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.neo4j.collection.pool.Pool;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.api.AccessMode;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KeyReadTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionHookException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder {
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHooks hooks;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts operations;
    private final StorageEngine storageEngine;
    private final TransactionTracer tracer;
    private final Pool<KernelTransactionImplementation> pool;
    private final Supplier<LegacyIndexTransactionState> legacyIndexTxStateSupplier;
    private final TransactionHeaderInformationFactory headerInformationFactory;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final StoreReadLayer storeLayer;
    private final Clock clock;
    private TransactionState txState;
    private LegacyIndexTransactionState legacyIndexTransactionState;
    private TransactionType transactionType;
    private TransactionHooks.TransactionHooksState hooksState;
    private final KernelStatement currentStatement;
    private final StorageStatement storageStatement;
    private KernelTransaction.CloseListener closeListener;
    private AccessMode accessMode;
    private Locks.Client locks;
    private boolean beforeHookInvoked;
    private boolean closing;
    private boolean closed;
    private boolean failure;
    private boolean success;
    private volatile boolean terminated;
    private long startTimeMillis;
    private long lastTransactionIdWhenStarted;
    private TransactionEvent transactionEvent;
    private KernelTransaction.Type type;

    public KernelTransactionImplementation(StatementOperationParts operations, SchemaWriteGuard schemaWriteGuard, TransactionHooks hooks, ConstraintIndexCreator constraintIndexCreator, Procedures procedures, TransactionHeaderInformationFactory headerInformationFactory, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, Supplier<LegacyIndexTransactionState> legacyIndexTxStateSupplier, Pool<KernelTransactionImplementation> pool, Clock clock, TransactionTracer tracer, StorageEngine storageEngine) {
        this.operations = operations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.hooks = hooks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.headerInformationFactory = headerInformationFactory;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.storeLayer = storageEngine.storeReadLayer();
        this.storageEngine = storageEngine;
        this.legacyIndexTxStateSupplier = legacyIndexTxStateSupplier;
        this.pool = pool;
        this.clock = clock;
        this.tracer = tracer;
        this.storageStatement = this.storeLayer.newStatement();
        this.currentStatement = new KernelStatement(this, this, operations, this.storageStatement, procedures);
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, Locks.Client locks, KernelTransaction.Type type, AccessMode accessMode) {
        this.type = type;
        this.locks = locks;
        this.beforeHookInvoked = false;
        this.terminated = false;
        this.success = false;
        this.failure = false;
        this.closed = false;
        this.closing = false;
        this.transactionType = TransactionType.READ;
        this.startTimeMillis = this.clock.currentTimeMillis();
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.transactionEvent = this.tracer.beginTransaction();
        assert (this.transactionEvent != null) : "transactionEvent was null!";
        this.accessMode = accessMode;
        this.currentStatement.initialize(locks);
        return this;
    }

    @Override
    public void success() {
        this.success = true;
    }

    @Override
    public void failure() {
        this.failure = true;
    }

    @Override
    public boolean shouldBeTerminated() {
        return this.terminated;
    }

    @Override
    public void markForTermination() {
        if (!this.terminated) {
            this.failure = true;
            this.terminated = true;
            if (!this.closed) {
                this.transactionMonitor.transactionTerminated(this.hasTxStateWithChanges());
            }
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    @Override
    public AccessMode mode() {
        return this.accessMode;
    }

    @Override
    public KernelStatement acquireStatement() {
        this.assertTransactionOpen();
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public void upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
        this.transactionType = this.transactionType.upgradeToDataTransaction();
    }

    public void upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.doUpgradeToSchemaTransaction();
        this.transactionType = this.transactionType.upgradeToSchemaTransaction();
    }

    public void doUpgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.schemaWriteGuard.assertSchemaWritesAllowed();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                try {
                    this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                }
                catch (DropIndexFailureException e) {
                    throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                }
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txState = new TxState();
        }
        return this.txState;
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.legacyIndexTransactionState != null ? this.legacyIndexTransactionState : (this.legacyIndexTransactionState = this.legacyIndexTxStateSupplier.get());
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void closeTransaction() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
        if (this.closeListener != null) {
            this.closeListener.notify(this.success);
        }
    }

    private void closeCurrentStatementIfAny() {
        this.currentStatement.forceClose();
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges() || this.hasLegacyIndexChanges();
    }

    private boolean hasLegacyIndexChanges() {
        return this.legacyIndexTransactionState != null && this.legacyIndexTransactionState.hasChanges();
    }

    private boolean hasDataChanges() {
        return this.hasTxStateWithChanges() && this.txState.hasDataChanges();
    }

    @Override
    public void close() throws TransactionFailureException {
        block10: {
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closeCurrentStatementIfAny();
            this.closing = true;
            try {
                if (this.failure || !this.success) {
                    this.rollback();
                    if (this.success) {
                        throw new TransactionFailureException((Status)Status.Transaction.MarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
                    }
                    break block10;
                }
                this.commit();
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionType(this.transactionType.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                }
                finally {
                    this.release();
                }
                throw throwable;
            }
        }
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionType(this.transactionType.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() throws TransactionFailureException {
        boolean success = false;
        try (CommitEvent commitEvent = this.transactionEvent.beginCommitEvent();){
            if (this.hasDataChanges()) {
                try {
                    this.hooksState = this.hooks.beforeCommit(this.txState, this, this.storageEngine.storeReadLayer(), this.storageStatement);
                    if (this.hooksState != null && this.hooksState.failed()) {
                        TransactionHookException cause = this.hooksState.failure();
                        throw new TransactionFailureException((Status)Status.Transaction.HookFailed, (Throwable)cause, "", new Object[0]);
                    }
                }
                finally {
                    this.beforeHookInvoked = true;
                }
            }
            if (this.hasChanges()) {
                ArrayList<StorageCommand> extractedCommands = new ArrayList<StorageCommand>();
                this.storageEngine.createCommands(extractedCommands, this.txState, this.storageStatement, this.locks, this.lastTransactionIdWhenStarted);
                if (this.hasLegacyIndexChanges()) {
                    this.legacyIndexTransactionState.extractCommands(extractedCommands);
                }
                if (!extractedCommands.isEmpty()) {
                    PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(extractedCommands);
                    TransactionHeaderInformation headerInformation = this.headerInformationFactory.create();
                    transactionRepresentation.setHeader(headerInformation.getAdditionalHeader(), headerInformation.getMasterId(), headerInformation.getAuthorId(), this.startTimeMillis, this.lastTransactionIdWhenStarted, this.clock.currentTimeMillis(), this.locks.getLockSessionId());
                    this.commitProcess.commit(new TransactionToApply(transactionRepresentation), commitEvent, TransactionApplicationMode.INTERNAL);
                }
            }
            success = true;
        }
        catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
            throw new ConstraintViolationTransactionFailureException(e.getUserMessage(new KeyReadTokenNameLookup(this.operations.keyReadOperations())), e);
        }
        finally {
            if (!success) {
                this.rollback();
            } else {
                this.afterCommit();
            }
        }
    }

    private void rollback() throws TransactionFailureException {
        block7: {
            try {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                catch (IllegalStateException | SecurityException e) {
                    throw new TransactionFailureException((Status)Status.Transaction.CouldNotRollback, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
                }
                if (this.txState == null) break block7;
                try {
                    this.txState.accept(new TxStateVisitor.Adapter(){

                        @Override
                        public void visitCreatedNode(long id) {
                            KernelTransactionImplementation.this.storeLayer.releaseNode(id);
                        }

                        @Override
                        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                            KernelTransactionImplementation.this.storeLayer.releaseRelationship(id);
                        }
                    });
                }
                catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
                    throw new IllegalStateException("Releasing locks during rollback should perform no constraints checking.", e);
                }
            }
            finally {
                this.afterRollback();
            }
        }
    }

    private void afterCommit() {
        try {
            this.closeTransaction();
            if (this.beforeHookInvoked) {
                this.hooks.afterCommit(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxStateWithChanges());
        }
    }

    private void afterRollback() {
        try {
            this.closeTransaction();
            if (this.beforeHookInvoked) {
                this.hooks.afterRollback(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxStateWithChanges());
        }
    }

    private void release() {
        this.locks.close();
        this.type = null;
        this.accessMode = null;
        this.transactionEvent = null;
        this.legacyIndexTransactionState = null;
        this.txState = null;
        this.hooksState = null;
        this.closeListener = null;
        this.pool.release((Object)this);
    }

    @Override
    public void registerCloseListener(KernelTransaction.CloseListener listener) {
        assert (this.closeListener == null);
        this.closeListener = listener;
    }

    @Override
    public KernelTransaction.Type transactionType() {
        return this.type;
    }

    @Override
    public KernelTransaction.Revertable restrict(AccessMode read) {
        AccessMode oldMode = this.accessMode;
        this.accessMode = read;
        return () -> {
            this.accessMode = oldMode;
        };
    }

    public String toString() {
        return "KernelTransaction[" + this.locks.getLockSessionId() + "]";
    }

    private static enum TransactionType {
        READ,
        DATA{

            @Override
            TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }
}

