/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.List;
import org.neo4j.kernel.configuration.AsciiDocItem;

public class AsciiDocListGenerator {
    private String listId;
    private String title;
    private boolean shortenDescription;

    public AsciiDocListGenerator(String listId, String title, boolean shortenDescription) {
        this.listId = listId;
        this.title = title;
        this.shortenDescription = shortenDescription;
    }

    public String generateListAndTableCombo(List<AsciiDocItem> items) {
        StringBuilder sb = new StringBuilder(200 * items.size());
        StringBuilder print = new StringBuilder(100 * items.size());
        if (this.listId != null) {
            sb.append("[[").append(this.listId).append("]]\n");
        }
        if (this.title != null) {
            sb.append('.').append(this.title).append('\n');
        }
        sb.append("ifndef::nonhtmloutput[]\n").append('\n').append("[options=\"header\"]\n").append("|===\n").append("|Name|Description\n");
        print.append("ifdef::nonhtmloutput[]\n").append('\n');
        for (AsciiDocItem item : items) {
            String id = item.id();
            String name = item.name();
            String description = item.description();
            if (this.shortenDescription) {
                int pos = description.indexOf(". ");
                if (pos == -1) {
                    pos = description.indexOf("; ");
                }
                if (pos > 10) {
                    description = description.substring(0, pos);
                }
            }
            sb.append("|<<").append(id).append(',').append(name).append(">>|").append(description);
            print.append("* <<").append(id).append(',').append(name).append(">>: ").append(description);
            if (!description.endsWith(".")) {
                sb.append('.');
                print.append('.');
            }
            sb.append('\n');
            print.append('\n');
        }
        sb.append("|===\n").append("endif::nonhtmloutput[]\n\n");
        print.append("endif::nonhtmloutput[]\n\n").append('\n');
        sb.append(print.toString());
        return sb.toString();
    }
}

