/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;

public class ListIndexesProcedure
extends CallableProcedure.BasicProcedure {
    protected ListIndexesProcedure(ProcedureSignature.ProcedureName procedureName) {
        super(ProcedureSignature.procedureSignature(procedureName).out("description", Neo4jTypes.NTString).build());
    }

    @Override
    public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) throws ProcedureException {
        Statement statement = ctx.get(CallableProcedure.Context.KERNEL_TRANSACTION).acquireStatement();
        StatementTokenNameLookup tokens = new StatementTokenNameLookup(statement.readOperations());
        List indexes = IteratorUtil.asList(statement.readOperations().indexesGetAll());
        indexes.sort((a, b) -> a.userDescription(tokens).compareTo(b.userDescription(tokens)));
        return Iterables.map(index -> new Object[]{"INDEX ON " + index.userDescription(tokens)}, (RawIterator)Iterables.asRawIterator(indexes.iterator()));
    }
}

