/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.DynamicNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.FixedIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicIntArray
extends DynamicNumberArray<IntArray>
implements IntArray {
    private final int defaultValue;

    public DynamicIntArray(NumberArrayFactory factory, long chunkSize, int defaultValue) {
        super(factory, chunkSize);
        this.defaultValue = defaultValue;
    }

    @Override
    public int get(long index) {
        IntArray chunk = (IntArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(this.index(index)) : this.defaultValue;
    }

    @Override
    public void set(long index, int value) {
        ((IntArray)this.ensureChunkAt(index)).set(this.index(index), value);
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            int intermediary = this.get(fromIndex + (long)i);
            this.set(fromIndex + (long)i, this.get(toIndex + (long)i));
            this.set(toIndex + (long)i, intermediary);
        }
    }

    @Override
    protected IntArray addChunk(long chunkSize) {
        return this.factory.newIntArray(chunkSize, this.defaultValue);
    }

    @Override
    public IntArray fixate() {
        return new FixedIntArray(this.chunks, this.chunkSize, this.defaultValue);
    }
}

