/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.helpers.collection.PrefetchingIterator;

class TraversalBranchImpl
implements TraversalBranch {
    private static final Iterator<Relationship> PRUNED_ITERATOR = new Iterator<Relationship>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Relationship next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    final TraversalBranch parent;
    private final Relationship howIGotHere;
    private final Node source;
    private Iterator<Relationship> relationships;
    private int depthAndEvaluationBits;
    private int expandedCount;

    TraversalBranchImpl(TraversalBranch parent, int depth, Node source, Relationship toHere) {
        this.parent = parent;
        this.source = source;
        this.howIGotHere = toHere;
        this.depthAndEvaluationBits = depth;
    }

    TraversalBranchImpl(TraversalBranch parent, Node source) {
        this.parent = parent;
        this.source = source;
        this.howIGotHere = null;
        this.depthAndEvaluationBits = 0;
    }

    protected void setEvaluation(Evaluation evaluation) {
        this.depthAndEvaluationBits &= 0x3FFFFFFF;
        this.depthAndEvaluationBits |= this.bitValue(evaluation.includes(), 30) | this.bitValue(evaluation.continues(), 31);
    }

    private int bitValue(boolean value, int bit) {
        return (value ? 1 : 0) << bit;
    }

    protected void expandRelationships(PathExpander expander) {
        this.relationships = this.continues() ? this.expandRelationshipsWithoutChecks(expander) : PRUNED_ITERATOR;
    }

    protected Iterator<Relationship> expandRelationshipsWithoutChecks(PathExpander expander) {
        Iterable<Relationship> iterable = expander.expand(this, BranchState.NO_STATE);
        return iterable.iterator();
    }

    protected boolean hasExpandedRelationships() {
        return this.relationships != null;
    }

    protected void evaluate(TraversalContext context) {
        this.setEvaluation(context.evaluate(this, null));
    }

    @Override
    public void initialize(PathExpander expander, TraversalContext metadata) {
        this.evaluate(metadata);
        this.expandRelationships(expander);
    }

    @Override
    public TraversalBranch next(PathExpander expander, TraversalContext context) {
        while (this.relationships.hasNext()) {
            Relationship relationship = this.relationships.next();
            if (relationship.equals(this.howIGotHere)) {
                context.unnecessaryRelationshipTraversed();
                continue;
            }
            ++this.expandedCount;
            Node node = relationship.getOtherNode(this.source);
            TraversalBranch next = this.newNextBranch(node, relationship);
            if (context.isUnique(next)) {
                context.relationshipTraversed();
                next.initialize(expander, context);
                return next;
            }
            context.unnecessaryRelationshipTraversed();
        }
        this.relationships = PRUNED_ITERATOR;
        return null;
    }

    protected TraversalBranch newNextBranch(Node node, Relationship relationship) {
        return new TraversalBranchImpl(this, this.length() + 1, node, relationship);
    }

    @Override
    public void prune() {
        this.relationships = PRUNED_ITERATOR;
    }

    @Override
    public int length() {
        return this.depthAndEvaluationBits & 0x3FFFFFFF;
    }

    @Override
    public TraversalBranch parent() {
        return this.parent;
    }

    @Override
    public int expanded() {
        return this.expandedCount;
    }

    @Override
    public boolean includes() {
        return (this.depthAndEvaluationBits & 0x40000000) != 0;
    }

    @Override
    public boolean continues() {
        return (this.depthAndEvaluationBits & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void evaluation(Evaluation eval) {
        this.setEvaluation(Evaluation.of(this.includes() & eval.includes(), this.continues() & eval.continues()));
    }

    @Override
    public Node startNode() {
        return this.findStartBranch().endNode();
    }

    private TraversalBranch findStartBranch() {
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            branch = branch.parent();
        }
        return branch;
    }

    @Override
    public Node endNode() {
        return this.source;
    }

    @Override
    public Relationship lastRelationship() {
        return this.howIGotHere;
    }

    @Override
    public Iterable<Relationship> relationships() {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            relationships.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        return relationships;
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new PrefetchingIterator<Relationship>(){
                    private TraversalBranch branch;
                    {
                        this.branch = TraversalBranchImpl.this;
                    }

                    @Override
                    protected Relationship fetchNextOrNull() {
                        Relationship relationship;
                        try {
                            relationship = this.branch != null ? this.branch.lastRelationship() : null;
                            this.branch = this.branch != null ? this.branch.parent() : null;
                        }
                        catch (Throwable throwable) {
                            this.branch = this.branch != null ? this.branch.parent() : null;
                            throw throwable;
                        }
                        return relationship;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Node> nodes() {
        LinkedList<Node> nodes = new LinkedList<Node>();
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            nodes.addFirst(branch.endNode());
            branch = branch.parent();
        }
        nodes.addFirst(branch.endNode());
        return nodes;
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new PrefetchingIterator<Node>(){
                    private TraversalBranch branch;
                    {
                        this.branch = TraversalBranchImpl.this;
                    }

                    @Override
                    protected Node fetchNextOrNull() {
                        try {
                            Node node = this.branch.length() >= 0 ? this.branch.endNode() : null;
                            return node;
                        }
                        finally {
                            this.branch = this.branch.parent();
                        }
                    }
                };
            }
        };
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        LinkedList<PropertyContainer> entities = new LinkedList<PropertyContainer>();
        TraversalBranch branch = this;
        while (branch.length() > 0) {
            entities.addFirst(branch.endNode());
            entities.addFirst(branch.lastRelationship());
            branch = branch.parent();
        }
        entities.addFirst(branch.endNode());
        return entities.iterator();
    }

    public int hashCode() {
        TraversalBranch branch = this;
        int hashCode = 1;
        while (branch.length() > 0) {
            Relationship relationship = branch.lastRelationship();
            hashCode = 31 * hashCode + relationship.hashCode();
            branch = branch.parent();
        }
        if (hashCode == 1) {
            hashCode = this.endNode().hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraversalBranch)) {
            return false;
        }
        TraversalBranch branch = this;
        TraversalBranch other = (TraversalBranch)obj;
        if (branch.length() != other.length()) {
            return false;
        }
        while (branch.length() > 0) {
            if (!branch.lastRelationship().equals(other.lastRelationship())) {
                return false;
            }
            branch = branch.parent();
            other = other.parent();
        }
        return true;
    }

    @Override
    public String toString() {
        return Paths.defaultPathToString(this);
    }

    @Override
    public Object state() {
        return null;
    }
}

