/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.CommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;

public class PhysicalLogCommandReaderV1_9
implements CommandReader {
    private final PhysicalNeoCommandReader reader = new PhysicalNeoCommandReader();
    private ReadableLogChannel channel;

    @Override
    public Command read(ReadableLogChannel channel) throws IOException {
        Command command;
        this.channel = channel;
        int commandType = 0;
        while (commandType == 0) {
            commandType = channel.get();
        }
        switch (commandType) {
            case 1: {
                command = new Command.NodeCommand();
                break;
            }
            case 2: {
                command = new Command.PropertyCommand();
                break;
            }
            case 5: {
                command = new Command.PropertyKeyTokenCommand();
                break;
            }
            case 3: {
                command = new Command.RelationshipCommand();
                break;
            }
            case 4: {
                command = new Command.RelationshipTypeTokenCommand();
                break;
            }
            case 8: {
                command = new Command.LabelTokenCommand();
                break;
            }
            case 6: {
                command = new Command.NeoStoreCommand();
                break;
            }
            case 7: {
                command = new Command.SchemaRuleCommand();
                break;
            }
            case 0: {
                command = null;
                break;
            }
            default: {
                throw new IOException("Unknown command type[" + commandType + "]");
            }
        }
        if (command != null && command.handle(this.reader)) {
            return null;
        }
        return command;
    }

    private class PhysicalNeoCommandReader
    extends CommandVisitor.Adapter {
        private PhysicalNeoCommandReader() {
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            long id = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            NodeRecord record = this.readNodeRecord(id);
            if (record == null) {
                return true;
            }
            command.init(record, record);
            return false;
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            RelationshipRecord record;
            long id = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                record = new RelationshipRecord(id, PhysicalLogCommandReaderV1_9.this.channel.getLong(), PhysicalLogCommandReaderV1_9.this.channel.getLong(), PhysicalLogCommandReaderV1_9.this.channel.getInt());
                record.setInUse(inUse);
                record.setFirstPrevRel(PhysicalLogCommandReaderV1_9.this.channel.getLong());
                record.setFirstNextRel(PhysicalLogCommandReaderV1_9.this.channel.getLong());
                record.setSecondPrevRel(PhysicalLogCommandReaderV1_9.this.channel.getLong());
                record.setSecondNextRel(PhysicalLogCommandReaderV1_9.this.channel.getLong());
                record.setNextProp(PhysicalLogCommandReaderV1_9.this.channel.getLong());
                record.setFirstInFirstChain(record.getFirstPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue());
                record.setFirstInSecondChain(record.getSecondPrevRel() == (long)Record.NO_PREV_RELATIONSHIP.intValue());
            } else {
                record = new RelationshipRecord(id, -1L, -1L, -1);
                record.setInUse(false);
            }
            command.init(record);
            return false;
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            long id = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            PropertyRecord record = this.readPropertyRecord(id);
            if (record == null) {
                return true;
            }
            command.init(record, record);
            return false;
        }

        @Override
        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
            boolean inUse;
            long id = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            byte inUseByte = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean bl = inUse = inUseByte == Record.IN_USE.byteValue();
            if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseByte);
            }
            short type = PhysicalLogCommandReaderV1_9.this.channel.getShort();
            RelationshipGroupRecord record = new RelationshipGroupRecord(id, type);
            record.setInUse(inUse);
            record.setNext(PhysicalLogCommandReaderV1_9.this.channel.getLong());
            record.setFirstOut(PhysicalLogCommandReaderV1_9.this.channel.getLong());
            record.setFirstIn(PhysicalLogCommandReaderV1_9.this.channel.getLong());
            record.setFirstLoop(PhysicalLogCommandReaderV1_9.this.channel.getLong());
            record.setOwningNode(PhysicalLogCommandReaderV1_9.this.channel.getLong());
            command.init(record);
            return false;
        }

        @Override
        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
            int id = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
            record.setInUse(inUse);
            record.setNameId(PhysicalLogCommandReaderV1_9.this.channel.getInt());
            int nrTypeRecords = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = this.readDynamicRecord();
                if (dr == null) {
                    return true;
                }
                record.addNameRecord(dr);
            }
            command.init(record);
            return false;
        }

        @Override
        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            int id = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            LabelTokenRecord record = new LabelTokenRecord(id);
            record.setInUse(inUse);
            record.setNameId(PhysicalLogCommandReaderV1_9.this.channel.getInt());
            int nrTypeRecords = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = this.readDynamicRecord();
                if (dr == null) {
                    return true;
                }
                record.addNameRecord(dr);
            }
            command.init(record);
            return false;
        }

        @Override
        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
            int id = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
            record.setInUse(inUse);
            record.setPropertyCount(PhysicalLogCommandReaderV1_9.this.channel.getInt());
            record.setNameId(PhysicalLogCommandReaderV1_9.this.channel.getInt());
            int recordNr = this.readDynamicRecords(record, CommandReaderFactory.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER);
            if (recordNr == -1) {
                return true;
            }
            command.init(record);
            return false;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
            this.readDynamicRecords(recordsBefore, CommandReaderFactory.COLLECTION_DYNAMIC_RECORD_ADDER);
            ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
            this.readDynamicRecords(recordsAfter, CommandReaderFactory.COLLECTION_DYNAMIC_RECORD_ADDER);
            byte isCreated = PhysicalLogCommandReaderV1_9.this.channel.get();
            if (1 == isCreated) {
                for (DynamicRecord record : recordsAfter) {
                    record.setCreated();
                }
            }
            PhysicalLogCommandReaderV1_9.this.channel.getLong();
            SchemaRule rule = ((DynamicRecord)IteratorUtil.first(recordsAfter)).inUse() ? this.readSchemaRule(recordsAfter) : this.readSchemaRule(recordsBefore);
            command.init(recordsBefore, recordsAfter, rule);
            return false;
        }

        @Override
        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
            long nextProp = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            NeoStoreRecord record = new NeoStoreRecord();
            record.setNextProp(nextProp);
            command.init(record);
            return false;
        }

        private NodeRecord readNodeRecord(long id) throws IOException {
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean inUse = false;
            if (inUseFlag == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            NodeRecord record = inUse ? new NodeRecord(id, false, PhysicalLogCommandReaderV1_9.this.channel.getLong(), PhysicalLogCommandReaderV1_9.this.channel.getLong()) : new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
            record.setInUse(inUse);
            return record;
        }

        DynamicRecord readDynamicRecord() throws IOException {
            long id = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
            int type = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
            DynamicRecord record = new DynamicRecord(id);
            record.setInUse(inUse, type);
            if (inUse) {
                record.setStartRecord((inUseFlag & Record.FIRST_IN_CHAIN.byteValue()) != 0);
                int nrOfBytes = PhysicalLogCommandReaderV1_9.this.channel.getInt();
                assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of " + "a dynamic record";
                long nextBlock = PhysicalLogCommandReaderV1_9.this.channel.getLong();
                assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of " + "a dynamic record";
                record.setNextBlock(nextBlock);
                byte[] data = new byte[nrOfBytes];
                PhysicalLogCommandReaderV1_9.this.channel.get(data, nrOfBytes);
                record.setData(data);
            }
            return record;
        }

        <T> int readDynamicRecords(T target, CommandReaderFactory.DynamicRecordAdder<T> adder) throws IOException {
            int numberOfRecords = PhysicalLogCommandReaderV1_9.this.channel.getInt();
            assert (numberOfRecords >= 0);
            int records = numberOfRecords;
            while (records-- > 0) {
                DynamicRecord read = this.readDynamicRecord();
                if (read == null) {
                    return -1;
                }
                adder.add(target, read);
            }
            return numberOfRecords;
        }

        private PropertyRecord readPropertyRecord(long id) throws IOException {
            long primitiveId;
            PropertyRecord record = new PropertyRecord(id);
            byte inUseFlag = PhysicalLogCommandReaderV1_9.this.channel.get();
            long nextProp = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            long prevProp = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            record.setNextProp(nextProp);
            record.setPrevProp(prevProp);
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            }
            boolean nodeProperty = true;
            if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
                nodeProperty = false;
            }
            if ((primitiveId = PhysicalLogCommandReaderV1_9.this.channel.getLong()) != -1L && nodeProperty) {
                record.setNodeId(primitiveId);
            } else if (primitiveId != -1L) {
                record.setRelId(primitiveId);
            }
            int nrPropBlocks = PhysicalLogCommandReaderV1_9.this.channel.get();
            assert (nrPropBlocks >= 0);
            if (nrPropBlocks > 0) {
                record.setInUse(true);
            }
            while (nrPropBlocks-- > 0) {
                PropertyBlock block = this.readPropertyBlock();
                if (block == null) {
                    return null;
                }
                record.addPropertyBlock(block);
            }
            if (this.readDynamicRecords(record, CommandReaderFactory.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER) == -1) {
                return null;
            }
            if (inUse && !record.inUse() || !inUse && record.inUse()) {
                throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
            }
            return record;
        }

        PropertyBlock readPropertyBlock() throws IOException {
            PropertyBlock toReturn = new PropertyBlock();
            byte blockSize = PhysicalLogCommandReaderV1_9.this.channel.get();
            assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
            long[] blocks = this.readLongs(blockSize / 8);
            assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
            assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
            toReturn.setValueBlocks(blocks);
            if (this.readDynamicRecords(toReturn, CommandReaderFactory.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
                return null;
            }
            return toReturn;
        }

        private long[] readLongs(int count) throws IOException {
            long[] result = new long[count];
            for (int i = 0; i < count; ++i) {
                result[i] = PhysicalLogCommandReaderV1_9.this.channel.getLong();
            }
            return result;
        }

        private SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
            SchemaRule rule;
            assert (IteratorUtil.first(recordsBefore).inUse()) : "Asked to deserialize schema records that were not in use.";
            ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
            try {
                rule = SchemaRule.Kind.deserialize(IteratorUtil.first(recordsBefore).getId(), deserialized);
            }
            catch (MalformedSchemaRuleException e) {
                throw Exceptions.launderedException(e);
            }
            return rule;
        }
    }
}

