/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;

public class NeoStoreBatchTransactionApplier
implements BatchTransactionApplier {
    private final NeoStores neoStores;
    private final CacheAccessBackDoor cacheAccess;
    private final LockService lockService;

    public NeoStoreBatchTransactionApplier(NeoStores store, CacheAccessBackDoor cacheAccess, LockService lockService) {
        this.neoStores = store;
        this.cacheAccess = cacheAccess;
        this.lockService = lockService;
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction) {
        throw new RuntimeException("NeoStoreTransactionApplier requires a LockGroup");
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction, LockGroup lockGroup) throws IOException {
        return new NeoStoreTransactionApplier(this.neoStores, this.cacheAccess, this.lockService, transaction.transactionId(), lockGroup);
    }

    @Override
    public void close() throws Exception {
    }
}

