/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;

public class IndexTransactionApplier
extends TransactionApplier.Adapter {
    private final IndexingService indexingService;
    private final ValidatedIndexUpdates indexUpdates;
    private final Consumer<IndexDescriptor> affectedIndexesConsumer;
    private final Consumer<NodeLabelUpdate> labelUpdateConsumer;

    public IndexTransactionApplier(IndexingService indexingService, ValidatedIndexUpdates indexUpdates, Consumer<IndexDescriptor> affectedIndexesConsumer, Consumer<NodeLabelUpdate> labelUpdateConsumer) {
        this.indexingService = indexingService;
        this.indexUpdates = indexUpdates;
        this.affectedIndexesConsumer = affectedIndexesConsumer;
        this.labelUpdateConsumer = labelUpdateConsumer;
    }

    @Override
    public void close() throws Exception {
        if (this.indexUpdates.hasChanges()) {
            this.indexUpdates.flush(this.affectedIndexesConsumer);
            this.indexUpdates.close();
        }
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeRecord before = command.getBefore();
        NodeRecord after = command.getAfter();
        NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
        NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
        if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
            long[] labelsBefore = labelFieldBefore.getIfLoaded();
            long[] labelsAfter = labelFieldAfter.getIfLoaded();
            if (labelsBefore != null && labelsAfter != null) {
                this.labelUpdateConsumer.accept(NodeLabelUpdate.labelChanges(command.getKey(), labelsBefore, labelsAfter));
            }
        }
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        if (command.getSchemaRule() instanceof IndexRule) {
            switch (command.getMode()) {
                case UPDATE: {
                    if (!((IndexRule)command.getSchemaRule()).isConstraintIndex()) break;
                    try {
                        this.indexingService.activateIndex(command.getSchemaRule().getId());
                        break;
                    }
                    catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                        throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                    }
                }
                case CREATE: {
                    this.indexingService.createIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                case DELETE: {
                    this.indexingService.dropIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        return false;
    }
}

