/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class IndexBatchTransactionApplier
implements BatchTransactionApplier {
    private final IndexingService indexingService;
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync;
    private Set<IndexDescriptor> affectedIndexes;
    private List<NodeLabelUpdate> labelUpdates;

    public IndexBatchTransactionApplier(IndexingService indexingService, WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync) {
        this.indexingService = indexingService;
        this.labelScanStoreSync = labelScanStoreSync;
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction) {
        return new IndexTransactionApplier(this.indexingService, transaction.validatedIndexUpdates(), indexDescriptor -> {
            if (this.affectedIndexes == null) {
                this.affectedIndexes = new HashSet<IndexDescriptor>();
            }
            this.affectedIndexes.add((IndexDescriptor)indexDescriptor);
        }, nodeLabelUpdate -> {
            if (this.labelUpdates == null) {
                this.labelUpdates = new ArrayList<NodeLabelUpdate>();
            }
            this.labelUpdates.add((NodeLabelUpdate)nodeLabelUpdate);
        });
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction, LockGroup lockGroup) throws IOException {
        return this.startTx(transaction);
    }

    @Override
    public void close() throws Exception {
        if (this.labelUpdates != null) {
            this.labelScanStoreSync.apply((Work)new LabelUpdateWork(this.labelUpdates));
        }
        if (this.affectedIndexes != null) {
            this.indexingService.flushAll(this.affectedIndexes);
        }
    }
}

