/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;

public class HighIdTransactionApplier
extends TransactionApplier.Adapter {
    private final NeoStores neoStores;
    private final Map<CommonAbstractStore, HighId> highIds = new HashMap<CommonAbstractStore, HighId>();

    public HighIdTransactionApplier(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeStore nodeStore = this.neoStores.getNodeStore();
        this.track((CommonAbstractStore)nodeStore, command);
        this.track((CommonAbstractStore)nodeStore.getDynamicLabelStore(), command.getAfter().getDynamicLabelRecords());
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        this.track((CommonAbstractStore)this.neoStores.getRelationshipStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyStore propertyStore = this.neoStores.getPropertyStore();
        this.track((CommonAbstractStore)propertyStore, command);
        for (PropertyBlock block : command.getAfter()) {
            switch (block.getType()) {
                case STRING: {
                    this.track((CommonAbstractStore)propertyStore.getStringStore(), block.getValueRecords());
                    break;
                }
                case ARRAY: {
                    this.track((CommonAbstractStore)propertyStore.getArrayStore(), block.getValueRecords());
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
        this.track((CommonAbstractStore)this.neoStores.getRelationshipGroupStore(), command);
        return false;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
        this.trackToken(this.neoStores.getRelationshipTypeTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
        this.trackToken(this.neoStores.getLabelTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
        this.trackToken(this.neoStores.getPropertyKeyTokenStore(), command);
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        SchemaStore schemaStore = this.neoStores.getSchemaStore();
        for (DynamicRecord record : command.getRecordsAfter()) {
            this.track((CommonAbstractStore)schemaStore, record.getId());
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        for (Map.Entry<CommonAbstractStore, HighId> highId : this.highIds.entrySet()) {
            highId.getKey().setHighestPossibleIdInUse(highId.getValue().id);
        }
    }

    private void track(CommonAbstractStore store, long id) {
        HighId highId = this.highIds.get(store);
        if (highId == null) {
            this.highIds.put(store, new HighId(id));
        } else {
            highId.track(id);
        }
    }

    private void track(CommonAbstractStore store, Command command) {
        this.track(store, command.getKey());
    }

    private void track(CommonAbstractStore store, Collection<? extends Abstract64BitRecord> records) {
        for (Abstract64BitRecord abstract64BitRecord : records) {
            this.track(store, abstract64BitRecord.getId());
        }
    }

    private <RECORD extends TokenRecord, TOKEN extends Token> void trackToken(TokenStore<RECORD, TOKEN> tokenStore, Command.TokenCommand<RECORD> tokenCommand) {
        this.track(tokenStore, tokenCommand);
        this.track((CommonAbstractStore)tokenStore.getNameStore(), ((TokenRecord)tokenCommand.getRecord()).getNameRecords());
    }

    private static class HighId {
        private long id;

        public HighId(long id) {
            this.id = id;
        }

        void track(long id) {
            if (id > this.id) {
                this.id = id;
            }
        }
    }
}

