/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20NodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20RelationshipStoreReader;

public class Legacy20Store
implements LegacyStore {
    public static final String LEGACY_VERSION = "v0.A.1";
    private final File storageFileName;
    private final Collection<Closeable> allStoreReaders = new ArrayList<Closeable>();
    private LegacyNodeStoreReader nodeStoreReader;
    private LegacyRelationshipStoreReader relStoreReader;
    private final FileSystemAbstraction fs;

    public Legacy20Store(FileSystemAbstraction fs, File storageFileName) throws IOException {
        this.fs = fs;
        this.storageFileName = storageFileName;
        Legacy20Store.assertLegacyAndCurrentVersionHaveSameLength(LEGACY_VERSION, "v0.A.7");
        this.initStorage();
    }

    static void assertLegacyAndCurrentVersionHaveSameLength(String legacyVersion, String currentVersion) {
        if (UTF8.encode(legacyVersion).length != UTF8.encode(currentVersion).length) {
            throw new IllegalStateException("Encoded version string length must remain the same between versions");
        }
    }

    protected void initStorage() throws IOException {
        this.nodeStoreReader = new Legacy20NodeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".nodestore.db"));
        this.allStoreReaders.add(this.nodeStoreReader);
        this.relStoreReader = new Legacy20RelationshipStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".relationshipstore.db"));
        this.allStoreReaders.add(this.relStoreReader);
    }

    @Override
    public File getStorageFileName() {
        return this.storageFileName;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    @Override
    public void close() throws IOException {
        for (Closeable storeReader : this.allStoreReaders) {
            storeReader.close();
        }
    }

    @Override
    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }

    @Override
    public LegacyRelationshipStoreReader getRelStoreReader() {
        return this.relStoreReader;
    }

    static void readIntoBuffer(StoreChannel fileChannel, ByteBuffer buffer, int nrOfBytes) {
        buffer.clear();
        buffer.limit(nrOfBytes);
        try {
            fileChannel.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buffer.flip();
    }
}

