/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;

public class UpgradableDatabase {
    private final FileSystemAbstraction fs;
    private final StoreVersionCheck storeVersionCheck;
    private final LegacyStoreVersionCheck legacyStoreVersionCheck;

    public UpgradableDatabase(FileSystemAbstraction fs, StoreVersionCheck storeVersionCheck, LegacyStoreVersionCheck legacyStoreVersionCheck) {
        this.fs = fs;
        this.storeVersionCheck = storeVersionCheck;
        this.legacyStoreVersionCheck = legacyStoreVersionCheck;
    }

    boolean storeFilesUpgradeable(File storeDirectory) {
        try {
            this.checkUpgradeable(storeDirectory);
            return true;
        }
        catch (StoreUpgrader.UnableToUpgradeException e) {
            return false;
        }
    }

    public String checkUpgradeable(File storeDirectory) {
        StoreVersionCheck.Result result = this.checkUpgradeableFor(storeDirectory, "v0.A.0");
        if (result.outcome.isSuccessful()) {
            return "v0.A.0";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.1");
        if (result.outcome.isSuccessful()) {
            return "v0.A.1";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.3");
        if (result.outcome.isSuccessful()) {
            return "v0.A.3";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.5");
        if (result.outcome.isSuccessful()) {
            return "v0.A.5";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.6");
        if (result.outcome.isSuccessful()) {
            return "v0.A.6";
        }
        switch (result.outcome) {
            case missingStoreFile: {
                throw new StoreUpgrader.UpgradeMissingStoreFilesException(this.getPathToStoreFile(storeDirectory, result));
            }
            case storeVersionNotFound: {
                throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(this.getPathToStoreFile(storeDirectory, result));
            }
            case unexpectedUpgradingStoreVersion: {
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(this.getPathToStoreFile(storeDirectory, result), "v0.A.6", result.actualVersion);
            }
            case storeNotCleanlyShutDown: {
                throw new StoreUpgrader.DatabaseNotCleanlyShutDownException();
            }
        }
        throw new IllegalArgumentException("Unexpected outcome: " + result.outcome.name());
    }

    private String getPathToStoreFile(File storeDirectory, StoreVersionCheck.Result result) {
        return new File(storeDirectory, result.storeFilename).getAbsolutePath();
    }

    private StoreVersionCheck.Result checkUpgradeableFor(File storeDirectory, String version) {
        if ("v0.A.6".equals(version)) {
            File neoStore = new File(storeDirectory, "neostore");
            StoreVersionCheck.Result result = this.storeVersionCheck.hasVersion(neoStore, version);
            if (!result.outcome.isSuccessful()) {
                return result;
            }
            PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDirectory, this.fs);
            LatestCheckPointFinder latestCheckPointFinder = new LatestCheckPointFinder(logFiles, this.fs, new VersionAwareLogEntryReader<ReadableLogChannel>());
            try {
                LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = latestCheckPointFinder.find(logFiles.getHighestLogVersion());
                if (!latestCheckPoint.commitsAfterCheckPoint) {
                    return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.ok, null, null);
                }
            }
            catch (IOException latestCheckPoint) {
                // empty catch block
            }
            return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.storeNotCleanlyShutDown, null, null);
        }
        StoreVersionCheck.Result result = null;
        for (StoreFile store : StoreFile.legacyStoreFilesForVersion(version)) {
            String expectedVersion = store.forVersion(version);
            File storeFile = new File(storeDirectory, store.storeFileName());
            result = this.legacyStoreVersionCheck.hasVersion(storeFile, expectedVersion, store.isOptional());
            if (result.outcome.isSuccessful()) continue;
            break;
        }
        return result;
    }

    public boolean hasCurrentVersion(File storeDir) {
        File neoStore = new File(storeDir, "neostore");
        StoreVersionCheck.Result result = this.storeVersionCheck.hasVersion(neoStore, "v0.A.7");
        switch (result.outcome) {
            case ok: {
                return true;
            }
            case missingStoreFile: {
                return true;
            }
            case storeVersionNotFound: {
                return false;
            }
            case unexpectedUpgradingStoreVersion: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown outcome: " + result.outcome.name());
    }
}

