/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.BatchTransactionApplierFacade;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.CountsStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.api.LegacyBatchIndexApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.DirectTxStateHolder;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.TransactionToRecordStateVisitor;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.HighIdBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.kernel.impl.transaction.command.NeoStoreBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class RecordStorageEngine
implements StorageEngine,
Lifecycle {
    private static final Setting<Boolean> use_read_locks_on_property_reads = Settings.setting("experimental.use_read_locks_on_property_reads", Settings.BOOLEAN, "true");
    private final StoreReadLayer storeLayer;
    private final IndexingService indexingService;
    private final NeoStores neoStores;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final DatabaseHealth databaseHealth;
    private final IndexConfigStore indexConfigStore;
    private final SchemaCache schemaCache;
    private final IntegrityValidator integrityValidator;
    private final IndexUpdatesValidator indexUpdatesValidator;
    private final CacheAccessBackDoor cacheAccess;
    private final LabelScanStore labelScanStore;
    private final DefaultSchemaIndexProviderMap providerMap;
    private final ProcedureCache procedureCache;
    private final LegacyIndexApplierLookup legacyIndexApplierLookup;
    private final Runnable schemaStateChangeCallback;
    private final SchemaStorage schemaStorage;
    private final ConstraintSemantics constraintSemantics;
    private final RecoveryIndexingUpdatesValidator indexUpdatesValidatorForRecovery;
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final LockService lockService;
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync;

    public RecordStorageEngine(File storeDir, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, FileSystemAbstraction fs, LogProvider logProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, Runnable schemaStateChangeCallback, ConstraintSemantics constraintSemantics, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LockService lockService, SchemaIndexProvider indexProvider, IndexingService.Monitor indexingServiceMonitor, DatabaseHealth databaseHealth, LabelScanStoreProvider labelScanStoreProvider, LegacyIndexProviderLookup legacyIndexProviderLookup, IndexConfigStore indexConfigStore) {
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokens;
        this.labelTokenHolder = labelTokens;
        this.schemaStateChangeCallback = schemaStateChangeCallback;
        this.constraintSemantics = constraintSemantics;
        this.lockService = lockService;
        this.databaseHealth = databaseHealth;
        this.indexConfigStore = indexConfigStore;
        StoreFactory storeFactory = new StoreFactory(storeDir, config, idGeneratorFactory, pageCache, fs, logProvider);
        this.neoStores = storeFactory.openAllNeoStores(true);
        try {
            this.schemaCache = new SchemaCache(constraintSemantics, Collections.emptyList());
            this.schemaStorage = new SchemaStorage(this.neoStores.getSchemaStore());
            this.providerMap = new DefaultSchemaIndexProviderMap(indexProvider);
            this.indexingService = IndexingService.create(new IndexSamplingConfig(config), scheduler, this.providerMap, new NeoStoreIndexStoreView(lockService, this.neoStores), tokenNameLookup, Iterables.toList(new SchemaStorage(this.neoStores.getSchemaStore()).allIndexRules()), logProvider, indexingServiceMonitor, schemaStateChangeCallback);
            this.integrityValidator = new IntegrityValidator(this.neoStores, this.indexingService);
            this.indexUpdatesValidator = new OnlineIndexUpdatesValidator(this.neoStores, databaseHealth, new PropertyLoader(this.neoStores), this.indexingService, IndexUpdateMode.BATCHED);
            this.cacheAccess = new BridgingCacheAccess(this.schemaCache, schemaStateChangeCallback, propertyKeyTokenHolder, relationshipTypeTokens, labelTokens);
            DiskLayer diskLayer = new DiskLayer(propertyKeyTokenHolder, labelTokens, relationshipTypeTokens, this.schemaStorage, this.neoStores, this.indexingService, RecordStorageEngine.storeStatementFactory(this.neoStores, config, lockService));
            this.procedureCache = new ProcedureCache();
            this.storeLayer = new CacheLayer(diskLayer, this.schemaCache, this.procedureCache);
            this.labelScanStore = labelScanStoreProvider.getLabelScanStore();
            this.legacyIndexApplierLookup = new LegacyIndexApplierLookup.Direct(legacyIndexProviderLookup);
            this.legacyIndexTransactionOrdering = new SynchronizedArrayIdOrderingQueue(20);
            this.indexUpdatesValidatorForRecovery = new RecoveryIndexingUpdatesValidator(this.indexingService);
            this.labelScanStoreSync = new WorkSync(this.labelScanStore::newWriter);
        }
        catch (Throwable failure) {
            this.neoStores.close();
            throw failure;
        }
    }

    private static Factory<StoreStatement> storeStatementFactory(NeoStores neoStores, Config config, LockService lockService) {
        LockService currentLockService = config.get(use_read_locks_on_property_reads) != false ? lockService : LockService.NO_LOCK_SERVICE;
        return () -> new StoreStatement(neoStores, currentLockService);
    }

    @Override
    public StoreReadLayer storeReadLayer() {
        return this.storeLayer;
    }

    @Override
    public Collection<Command> createCommands(TransactionState txState, LegacyIndexTransactionState legacyIndexTransactionState, Locks.Client locks, StatementOperationParts operations, StoreStatement storeStatement, long lastTransactionIdWhenStarted) throws TransactionFailureException, CreateConstraintFailureException, ConstraintValidationKernelException {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (txState == null) {
            legacyIndexTransactionState.extractCommands(commands);
            return commands;
        }
        NeoStoreTransactionContext context = new NeoStoreTransactionContext(this.neoStores, locks);
        TransactionRecordState recordState = new TransactionRecordState(this.neoStores, this.integrityValidator, context);
        recordState.initialize(lastTransactionIdWhenStarted);
        TxStateVisitor txStateVisitor = new TransactionToRecordStateVisitor(recordState, this.schemaStateChangeCallback, this.schemaStorage, this.constraintSemantics, this.providerMap, legacyIndexTransactionState, this.procedureCache);
        CountsRecordState countsRecordState = new CountsRecordState();
        txStateVisitor = this.constraintSemantics.decorateTxStateVisitor(operations, storeStatement, this.storeLayer, new DirectTxStateHolder(txState, legacyIndexTransactionState), txStateVisitor);
        try (TxStateVisitor visitor = txStateVisitor = new TransactionCountingStateVisitor(txStateVisitor, this.storeLayer, txState, countsRecordState);){
            txState.accept(txStateVisitor);
        }
        recordState.extractCommands(commands);
        legacyIndexTransactionState.extractCommands(commands);
        countsRecordState.extractCommands(commands);
        return commands;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(TransactionToApply batch, TransactionApplicationMode mode) throws Exception {
        try (BatchTransactionApplierFacade batchApplier = this.applier(mode);){
            TransactionToApply tx = batch;
            while (tx != null) {
                try {
                    LockGroup locks = new LockGroup();
                    Throwable throwable = null;
                    try {
                        this.ensureValidatedIndexUpdates(tx);
                        try (TransactionApplier txApplier = batchApplier.startTx(tx, locks);){
                            tx.transactionRepresentation().accept(txApplier);
                        }
                        tx = tx.next();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (locks == null) continue;
                        if (throwable != null) {
                            try {
                                locks.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        locks.close();
                    }
                }
                catch (Throwable cause) {
                    this.databaseHealth.panic(cause);
                    throw cause;
                    return;
                }
            }
        }
    }

    private BatchTransactionApplierFacade applier(TransactionApplicationMode mode) {
        ArrayList<BatchTransactionApplier> appliers = new ArrayList<BatchTransactionApplier>();
        appliers.add(new NeoStoreBatchTransactionApplier(this.neoStores, this.cacheAccess, this.lockService));
        if (mode.needsHighIdTracking()) {
            appliers.add(new HighIdBatchTransactionApplier(this.neoStores));
        }
        if (mode.needsCacheInvalidationOnUpdates()) {
            appliers.add(new CacheInvalidationBatchTransactionApplier(this.neoStores, this.cacheAccess));
        }
        appliers.add(new IndexBatchTransactionApplier(this.indexingService, this.labelScanStoreSync));
        appliers.add(new LegacyBatchIndexApplier(this.indexConfigStore, this.legacyIndexApplierLookup, this.legacyIndexTransactionOrdering, mode));
        appliers.add(new CountsStoreBatchTransactionApplier(this.neoStores.getCounts(), mode));
        return new BatchTransactionApplierFacade(appliers.toArray(new BatchTransactionApplier[appliers.size()]));
    }

    private void ensureValidatedIndexUpdates(TransactionToApply tx) throws IOException {
        if (tx.validatedIndexUpdates() == null) {
            tx.validatedIndexUpdates(this.indexUpdatesValidator.validate(tx.transactionRepresentation()));
        }
    }

    @Override
    public IndexUpdatesValidator indexUpdatesValidatorForRecovery() {
        return this.indexUpdatesValidatorForRecovery;
    }

    @Override
    public TransactionIdStore transactionIdStore() {
        return this.neoStores.getMetaDataStore();
    }

    @Override
    public LogVersionRepository logVersionRepository() {
        return this.neoStores.getMetaDataStore();
    }

    @Override
    public ProcedureCache procedureCache() {
        return this.procedureCache;
    }

    @Override
    public NeoStores neoStores() {
        return this.neoStores;
    }

    @Override
    public MetaDataStore metaDataStore() {
        return this.neoStores.getMetaDataStore();
    }

    @Override
    public IndexingService indexingService() {
        return this.indexingService;
    }

    @Override
    public IndexUpdatesValidator indexUpdatesValidator() {
        return this.indexUpdatesValidator;
    }

    @Override
    public LabelScanStore labelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public IntegrityValidator integrityValidator() {
        return this.integrityValidator;
    }

    @Override
    public SchemaIndexProviderMap schemaIndexProviderMap() {
        return this.providerMap;
    }

    @Override
    public CacheAccessBackDoor cacheAccess() {
        return this.cacheAccess;
    }

    @Override
    public LegacyIndexApplierLookup legacyIndexApplierLookup() {
        return this.legacyIndexApplierLookup;
    }

    @Override
    public IndexConfigStore indexConfigStore() {
        return this.indexConfigStore;
    }

    @Override
    public IdOrderingQueue legacyIndexTransactionOrdering() {
        return this.legacyIndexTransactionOrdering;
    }

    @Override
    public void init() throws Throwable {
        this.indexingService.init();
        this.labelScanStore.init();
    }

    @Override
    public void start() throws Throwable {
        this.neoStores.makeStoreOk();
        this.propertyKeyTokenHolder.setInitialTokens(this.neoStores.getPropertyKeyTokenStore().getTokens(Integer.MAX_VALUE));
        this.relationshipTypeTokenHolder.setInitialTokens(this.neoStores.getRelationshipTypeTokenStore().getTokens(Integer.MAX_VALUE));
        this.labelTokenHolder.setInitialTokens(this.neoStores.getLabelTokenStore().getTokens(Integer.MAX_VALUE));
        this.neoStores.rebuildCountStoreIfNeeded();
        this.loadSchemaCache();
        this.indexingService.start();
        this.labelScanStore.start();
    }

    @Override
    public void loadSchemaCache() {
        List<SchemaRule> schemaRules = Iterables.toList(this.neoStores.getSchemaStore().loadAllSchemaRules());
        this.schemaCache.load(schemaRules);
    }

    @Override
    public void stop() throws Throwable {
        this.labelScanStore.stop();
        this.indexingService.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.labelScanStore.shutdown();
        this.indexingService.shutdown();
    }
}

