/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.Command;

public abstract class IndexCommand
extends Command {
    public static final byte VALUE_TYPE_NULL = 0;
    public static final byte VALUE_TYPE_SHORT = 1;
    public static final byte VALUE_TYPE_INT = 2;
    public static final byte VALUE_TYPE_LONG = 3;
    public static final byte VALUE_TYPE_FLOAT = 4;
    public static final byte VALUE_TYPE_DOUBLE = 5;
    public static final byte VALUE_TYPE_STRING = 6;
    private byte commandType;
    protected int indexNameId;
    protected byte entityType;
    protected long entityId;
    protected int keyId;
    protected byte valueType;
    protected Object value;

    protected void init(byte commandType, int indexNameId, byte entityType, long entityId, int keyId, Object value) {
        this.commandType = commandType;
        this.indexNameId = indexNameId;
        this.entityType = entityType;
        this.entityId = entityId;
        this.keyId = keyId;
        this.value = value;
        this.valueType = IndexCommand.valueTypeOf(value);
    }

    public int getIndexNameId() {
        return this.indexNameId;
    }

    public byte getEntityType() {
        return this.entityType;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public Object getValue() {
        return this.value;
    }

    public byte startNodeNeedsLong() {
        return 0;
    }

    public byte endNodeNeedsLong() {
        return 0;
    }

    private static byte valueTypeOf(Object value) {
        int valueType = 0;
        valueType = value == null ? 0 : (value instanceof Number ? (value instanceof Float ? 4 : (value instanceof Double ? 5 : (value instanceof Long ? 3 : (value instanceof Short ? 1 : 2)))) : 6);
        return (byte)valueType;
    }

    protected static byte needsLong(long value) {
        return value > Integer.MAX_VALUE ? (byte)1 : 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexCommand that = (IndexCommand)o;
        return this.commandType == that.commandType && this.indexNameId == that.indexNameId && this.entityType == that.entityType && this.entityId == that.entityId && this.keyId == that.keyId && this.valueType == that.valueType && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commandType, this.indexNameId, this.entityType, this.entityId, this.keyId, this.valueType, this.value);
    }

    public byte getCommandType() {
        return this.commandType;
    }

    public byte getValueType() {
        return this.valueType;
    }

    public static class CreateCommand
    extends IndexCommand {
        private Map<String, String> config;

        public void init(int indexNameId, byte entityType, Map<String, String> config) {
            super.init((byte)15, indexNameId, entityType, 0L, 0, null);
            this.config = config;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CreateCommand that = (CreateCommand)o;
            return Objects.equals(this.config, that.config);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.config);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexCreateCommand(this);
        }

        @Override
        public String toString() {
            return String.format("Create%sIndex[index:%d, config:%s]", IndexEntityType.byId(this.entityType).nameToLowerCase(), this.indexNameId, this.config);
        }
    }

    public static class DeleteCommand
    extends IndexCommand {
        public void init(int indexNameId, byte entityType) {
            super.init((byte)14, indexNameId, entityType, 0L, 0, null);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexDeleteCommand(this);
        }

        @Override
        public String toString() {
            return "Delete[index:" + this.indexNameId + ", type:" + IndexEntityType.byId(this.entityType).nameToLowerCase() + "]";
        }
    }

    public static class RemoveCommand
    extends IndexCommand {
        public void init(int indexNameId, byte entityType, long entityId, int keyId, Object value) {
            super.init((byte)13, indexNameId, entityType, entityId, keyId, value);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexRemoveCommand(this);
        }

        @Override
        public String toString() {
            return String.format("Remove%s[index:%d, id:%d, key:%d, value:%s]", IndexEntityType.byId(this.entityType).nameToLowerCase(), this.indexNameId, this.entityId, this.keyId, this.value);
        }
    }

    public static class AddRelationshipCommand
    extends IndexCommand {
        private long startNode;
        private long endNode;

        public void init(int indexNameId, long entityId, int keyId, Object value, long startNode, long endNode) {
            super.init((byte)12, indexNameId, IndexEntityType.Relationship.id(), entityId, keyId, value);
            this.startNode = startNode;
            this.endNode = endNode;
        }

        public long getStartNode() {
            return this.startNode;
        }

        public long getEndNode() {
            return this.endNode;
        }

        @Override
        public byte startNodeNeedsLong() {
            return AddRelationshipCommand.needsLong(this.startNode);
        }

        @Override
        public byte endNodeNeedsLong() {
            return AddRelationshipCommand.needsLong(this.endNode);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AddRelationshipCommand that = (AddRelationshipCommand)o;
            return this.startNode == that.startNode && this.endNode == that.endNode;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.startNode, this.endNode);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexAddRelationshipCommand(this);
        }

        @Override
        public String toString() {
            return "AddRelationship[index:" + this.indexNameId + ", id:" + this.entityId + ", key:" + this.keyId + ", value:" + this.value + "(" + (this.value != null ? this.value.getClass().getSimpleName() : "null") + ")" + ", startNode:" + this.startNode + ", endNode:" + this.endNode + "]";
        }
    }

    public static class AddNodeCommand
    extends IndexCommand {
        public void init(int indexNameId, long entityId, int keyId, Object value) {
            super.init((byte)11, indexNameId, IndexEntityType.Node.id(), entityId, keyId, value);
        }

        @Override
        public boolean handle(CommandVisitor visitor) throws IOException {
            return visitor.visitIndexAddNodeCommand(this);
        }

        @Override
        public String toString() {
            return "AddNode[index:" + this.indexNameId + ", id:" + this.entityId + ", key:" + this.keyId + ", value:" + this.value + "]";
        }
    }
}

