/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.Supplier;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ThreadToStatementContextBridge
extends LifecycleAdapter
implements Supplier<Statement> {
    private final ThreadLocal<TopLevelTransaction> threadToTransactionMap = new ThreadLocal();
    private boolean isShutdown;

    public boolean hasTransaction() {
        this.checkIfShutdown();
        return this.threadToTransactionMap.get() != null;
    }

    public void bindTransactionToCurrentThread(TopLevelTransaction transaction) {
        if (this.threadToTransactionMap.get() != null) {
            throw new IllegalStateException(Thread.currentThread() + " already has a transaction bound");
        }
        this.threadToTransactionMap.set(transaction);
    }

    public void unbindTransactionFromCurrentThread() {
        this.threadToTransactionMap.remove();
    }

    @Override
    public Statement get() {
        this.checkIfShutdown();
        return this.getKernelTransactionBoundToThisThread(true).acquireStatement();
    }

    private void assertInUnterminatedTransaction(TopLevelTransaction transaction) {
        if (transaction == null) {
            throw new NotInTransactionException();
        }
        if (transaction.getTransaction().shouldBeTerminated()) {
            throw new TransactionTerminatedException();
        }
    }

    public void assertInUnterminatedTransaction() {
        this.checkIfShutdown();
        this.assertInUnterminatedTransaction(this.threadToTransactionMap.get());
    }

    @Override
    public void shutdown() throws Throwable {
        this.isShutdown = true;
    }

    private void checkIfShutdown() {
        if (this.isShutdown) {
            throw new DatabaseShutdownException();
        }
    }

    public TopLevelTransaction getTopLevelTransactionBoundToThisThread(boolean strict) {
        TopLevelTransaction transaction = this.threadToTransactionMap.get();
        if (strict) {
            this.assertInUnterminatedTransaction(transaction);
        }
        return transaction;
    }

    public KernelTransaction getKernelTransactionBoundToThisThread(boolean strict) {
        TopLevelTransaction tx = this.getTopLevelTransactionBoundToThisThread(strict);
        return tx != null ? tx.getTransaction() : null;
    }
}

