/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class InMemoryTokenCache<TOKEN extends Token> {
    private final Map<String, Integer> nameToId = new CopyOnWriteHashMap<String, Integer>();
    private final Map<Integer, TOKEN> idToToken = new CopyOnWriteHashMap<Integer, TOKEN>();
    private final Class<? extends TokenHolder> owningClass;

    public InMemoryTokenCache(Class<? extends TokenHolder> owningClass) {
        this.owningClass = owningClass;
    }

    public void clear() {
        this.nameToId.clear();
        this.idToToken.clear();
    }

    private static void putAndEnsureUnique(Map<String, Integer> nameToId, Token token, Class<? extends TokenHolder> owningClass) {
        Integer previous = nameToId.put(token.name(), token.id());
        if (previous != null && previous.intValue() != token.id()) {
            throw new NonUniqueTokenException(owningClass, token.name(), token.id(), previous);
        }
    }

    public void putAll(List<TOKEN> tokens) throws NonUniqueTokenException {
        HashMap<String, Integer> newNameToId = new HashMap<String, Integer>();
        HashMap<Integer, Token> newIdToToken = new HashMap<Integer, Token>();
        for (Token token : tokens) {
            InMemoryTokenCache.putAndEnsureUnique(newNameToId, token, this.owningClass);
            newIdToToken.put(token.id(), token);
        }
        this.nameToId.putAll(newNameToId);
        this.idToToken.putAll(newIdToToken);
    }

    public void put(TOKEN token) throws NonUniqueTokenException {
        InMemoryTokenCache.putAndEnsureUnique(this.nameToId, token, this.owningClass);
        this.idToToken.put(((Token)token).id(), token);
    }

    public Integer getId(String name) {
        return this.nameToId.get(name);
    }

    public TOKEN getToken(int id) {
        return (TOKEN)((Token)this.idToToken.get(id));
    }

    public Iterable<TOKEN> allTokens() {
        return this.idToToken.values();
    }
}

