/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;

public class PropertyBlockCursor {
    private PropertyBlock[] blockRecords;
    private PropertyBlock current;
    private int blockRecordsCursor;
    private int index;
    private Supplier<PropertyStore> propertyStore;

    public PropertyBlockCursor(PropertyStore propertyStore) {
        this.propertyStore = Suppliers.singleton((Object)propertyStore);
    }

    public void init(PropertyBlock[] blockRecords, int blockRecordsCursor) {
        this.blockRecords = blockRecords;
        this.blockRecordsCursor = blockRecordsCursor;
        this.index = 0;
    }

    public boolean next() {
        if (this.index < this.blockRecordsCursor) {
            this.current = this.blockRecords[this.index];
            ++this.index;
            return true;
        }
        return false;
    }

    public PropertyBlock getPropertyBlock() {
        return this.current;
    }

    public void close() {
    }

    public DefinedProperty getProperty() {
        return this.current.newPropertyData(this.propertyStore);
    }

    public Object getValue() {
        return this.current.getType().getValue(this.current, this.propertyStore.get());
    }
}

