/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import java.util.function.Supplier;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.cursor.TxAllPropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxSinglePropertyCursor;
import org.neo4j.kernel.impl.api.state.PropertyContainerState;
import org.neo4j.kernel.impl.api.state.StateDefaults;
import org.neo4j.kernel.impl.api.state.TxState;

public interface RelationshipState
extends PropertyContainerState {
    public long getId();

    public <EX extends Exception> boolean accept(RelationshipVisitor<EX> var1) throws EX;

    public static abstract class Defaults
    extends StateDefaults<Long, RelationshipState, Mutable> {
        private static final RelationshipState DEFAULT = new RelationshipState(){

            private UnsupportedOperationException notDefined(String field) {
                return new UnsupportedOperationException(field + " not defined");
            }

            @Override
            public long getId() {
                throw this.notDefined("id");
            }

            @Override
            public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) throws EX {
                return false;
            }

            @Override
            public Iterator<DefinedProperty> addedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<DefinedProperty> changedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<Integer> removedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<DefinedProperty> addedAndChangedProperties() {
                return IteratorUtil.emptyIterator();
            }

            @Override
            public Iterator<DefinedProperty> augmentProperties(Iterator<DefinedProperty> iterator) {
                return iterator;
            }

            @Override
            public Cursor<PropertyItem> augmentPropertyCursor(Supplier<TxAllPropertyCursor> propertyCursor, Cursor<PropertyItem> cursor) {
                return cursor;
            }

            @Override
            public Cursor<PropertyItem> augmentSinglePropertyCursor(Supplier<TxSinglePropertyCursor> propertyCursor, Cursor<PropertyItem> cursor, int propertyKeyId) {
                return cursor;
            }

            @Override
            public void accept(PropertyContainerState.Visitor visitor) {
            }
        };

        @Override
        Mutable createValue(Long id, TxState state) {
            return new Mutable((long)id);
        }

        @Override
        RelationshipState defaultValue() {
            return DEFAULT;
        }
    }

    public static class Mutable
    extends PropertyContainerState.Mutable
    implements RelationshipState {
        private long startNode = -1L;
        private long endNode = -1L;
        private int type = -1;

        private Mutable(long id) {
            super(id, EntityType.RELATIONSHIP);
        }

        public void setMetaData(long startNode, long endNode, int type) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.type = type;
        }

        @Override
        public <EX extends Exception> boolean accept(RelationshipVisitor<EX> visitor) throws EX {
            if (this.type != -1) {
                visitor.visit(this.getId(), this.type, this.startNode, this.endNode);
                return true;
            }
            return false;
        }
    }
}

