/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;

class OnlineValidatedIndexUpdates
implements ValidatedIndexUpdates {
    private final Reservation reservation;
    private final Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex;
    private final IndexUpdaterMap indexUpdaters;

    OnlineValidatedIndexUpdates(Reservation reservation, Map<IndexDescriptor, List<NodePropertyUpdate>> updatesByIndex, IndexUpdaterMap indexUpdaters) {
        this.reservation = reservation;
        this.updatesByIndex = updatesByIndex;
        this.indexUpdaters = indexUpdaters;
    }

    @Override
    public void flush(Consumer<IndexDescriptor> affectedIndexes) throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
        for (Map.Entry<IndexDescriptor, List<NodePropertyUpdate>> entry : this.updatesByIndex.entrySet()) {
            IndexDescriptor indexDescriptor = entry.getKey();
            affectedIndexes.accept(indexDescriptor);
            List<NodePropertyUpdate> updates = entry.getValue();
            IndexUpdater updater = this.indexUpdaters.getUpdater(indexDescriptor);
            for (NodePropertyUpdate update : updates) {
                updater.process(update);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.reservation.release();
        }
        finally {
            this.indexUpdaters.close();
        }
    }

    @Override
    public boolean hasChanges() {
        return !this.updatesByIndex.isEmpty();
    }
}

