/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.LazyIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.internal.DatabaseHealth;

public class OnlineIndexUpdatesValidator
implements IndexUpdatesValidator {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final PropertyLoader propertyLoader;
    private final IndexingService indexing;
    private final DatabaseHealth databaseHealth;
    private final IndexUpdateMode updateMode;

    public OnlineIndexUpdatesValidator(NeoStores neoStore, DatabaseHealth databaseHealth, PropertyLoader propertyLoader, IndexingService indexing, IndexUpdateMode updateMode) {
        this.databaseHealth = databaseHealth;
        this.updateMode = updateMode;
        this.nodeStore = neoStore.getNodeStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.propertyLoader = propertyLoader;
        this.indexing = indexing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidatedIndexUpdates validate(TransactionRepresentation transaction) throws IOException {
        try (NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();){
            Object object;
            try {
                TransactionApplier txApplier = extractor.startTx(new TransactionToApply(transaction));
                object = null;
                try {
                    transaction.accept(txApplier);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (txApplier != null) {
                        if (object != null) {
                            try {
                                txApplier.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            txApplier.close();
                        }
                    }
                }
            }
            catch (IOException cause) {
                this.databaseHealth.panic(cause);
                throw cause;
            }
            if (!extractor.containsAnyNodeOrPropertyUpdate()) {
                ValidatedIndexUpdates cause = ValidatedIndexUpdates.NONE;
                return cause;
            }
            LazyIndexUpdates updates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, extractor.propertyCommandsByNodeIds, extractor.nodeCommandsById);
            object = this.indexing.validate(updates, this.updateMode);
            return object;
        }
        catch (Exception cause) {
            this.databaseHealth.panic(cause);
            throw new IOException(cause);
        }
    }
}

