/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;

public class NodePropertyCommandsExtractor
extends TransactionApplier.Adapter
implements BatchTransactionApplier {
    final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommandsById = Primitive.longObjectMap();
    final PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds = Primitive.longObjectMap();

    @Override
    public TransactionApplier startTx(TransactionToApply transaction) {
        this.nodeCommandsById.clear();
        this.propertyCommandsByNodeIds.clear();
        return this;
    }

    @Override
    public TransactionApplier startTx(TransactionToApply transaction, LockGroup lockGroup) {
        return this.startTx(transaction);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.nodeCommandsById.put(command.getKey(), (Object)command);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyRecord record = command.getAfter();
        if (record.isNodeSet()) {
            long nodeId = command.getAfter().getNodeId();
            ArrayList<Command.PropertyCommand> group = (ArrayList<Command.PropertyCommand>)this.propertyCommandsByNodeIds.get(nodeId);
            if (group == null) {
                group = new ArrayList<Command.PropertyCommand>();
                this.propertyCommandsByNodeIds.put(nodeId, group);
            }
            group.add(command);
        }
        return false;
    }

    public boolean containsAnyNodeOrPropertyUpdate() {
        return !this.nodeCommandsById.isEmpty() || !this.propertyCommandsByNodeIds.isEmpty();
    }

    public void visitUpdatedNodeIds(PrimitiveLongVisitor<RuntimeException> updatedNodeVisitor) {
        try (PrimitiveLongSet uniqueIds = Primitive.longSet((int)(this.nodeCommandsById.size() + this.propertyCommandsByNodeIds.size()));){
            uniqueIds.addAll(this.nodeCommandsById.iterator());
            uniqueIds.addAll(this.propertyCommandsByNodeIds.iterator());
            uniqueIds.visitKeys(updatedNodeVisitor);
        }
    }

    public PrimitiveLongObjectMap<Command.NodeCommand> nodeCommandsById() {
        return this.nodeCommandsById;
    }

    public PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds() {
        return this.propertyCommandsByNodeIds;
    }
}

