/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.cursor.TxAbstractRelationshipCursor;

public class TxSingleRelationshipCursor
extends TxAbstractRelationshipCursor {
    private long nextId;

    public TxSingleRelationshipCursor(TransactionState state, Consumer<TxSingleRelationshipCursor> instanceCache) {
        super(state, instanceCache);
    }

    public TxSingleRelationshipCursor init(Cursor<RelationshipItem> cursor, long id) {
        this.nextId = id;
        super.init(cursor);
        return this;
    }

    public boolean next() {
        if (this.state.relationshipIsDeletedInThisTx(this.nextId)) {
            this.visit(-1L, -1, -1L, -1L);
            return false;
        }
        boolean exists = this.cursor.next();
        this.relationshipIsAddedInThisTx = this.state.relationshipIsAddedInThisTx(this.nextId);
        if (exists || this.relationshipIsAddedInThisTx) {
            if (this.relationshipIsAddedInThisTx) {
                this.state.relationshipVisit(this.nextId, this);
            } else {
                RelationshipItem relationshipItem = (RelationshipItem)this.cursor.get();
                this.visit(this.nextId, relationshipItem.type(), relationshipItem.startNode(), relationshipItem.endNode());
            }
            this.relationshipState = this.state.getRelationshipState(this.nextId);
            return true;
        }
        this.visit(-1L, -1, -1L, -1L);
        this.relationshipState = null;
        return false;
    }
}

