/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.cursor.TxAbstractPropertyCursor;
import org.neo4j.kernel.impl.util.VersionedHashMap;

public class TxSinglePropertyCursor
extends TxAbstractPropertyCursor {
    private int propertyKeyId;
    private boolean seekFoundIt;

    public TxSinglePropertyCursor(Consumer<TxAbstractPropertyCursor> instanceCache) {
        super(instanceCache);
    }

    public Cursor<PropertyItem> init(Cursor<PropertyItem> cursor, VersionedHashMap<Integer, DefinedProperty> addedProperties, VersionedHashMap<Integer, DefinedProperty> changedProperties, VersionedHashMap<Integer, DefinedProperty> removedProperties, int propertyKeyId) {
        super.init(cursor, addedProperties, changedProperties, removedProperties);
        this.propertyKeyId = propertyKeyId;
        return this;
    }

    public boolean next() {
        if (this.propertyKeyId == -1) {
            return false;
        }
        try {
            Property property;
            this.seekFoundIt = false;
            if (this.changedProperties != null && (property = (Property)this.changedProperties.get(this.propertyKeyId)) != null) {
                this.property = (DefinedProperty)property;
                boolean bl = true;
                return bl;
            }
            if (this.addedProperties != null && (property = (Property)this.addedProperties.get(this.propertyKeyId)) != null) {
                this.property = (DefinedProperty)property;
                boolean bl = true;
                return bl;
            }
            if (this.removedProperties != null && this.removedProperties.containsKey(this.propertyKeyId)) {
                this.property = null;
                boolean bl = false;
                return bl;
            }
            if (this.cursor.next()) {
                this.property = null;
                this.seekFoundIt = true;
                boolean bl = true;
                return bl;
            }
            this.property = null;
            boolean bl = false;
            return bl;
        }
        finally {
            this.propertyKeyId = -1;
        }
    }

    @Override
    public PropertyItem get() {
        if (this.property == null && !this.seekFoundIt) {
            throw new IllegalStateException();
        }
        if (this.seekFoundIt) {
            this.property = Property.property(((PropertyItem)this.cursor.get()).propertyKeyId(), ((PropertyItem)this.cursor.get()).value());
        }
        this.seekFoundIt = false;
        return super.get();
    }
}

