/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.LabelItem;
import org.neo4j.kernel.impl.api.cursor.TxLabelCursor;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;

public class TxSingleLabelCursor
extends TxLabelCursor {
    private int labelId;

    public TxSingleLabelCursor(Consumer<TxSingleLabelCursor> instanceCache) {
        super(instanceCache);
    }

    public TxSingleLabelCursor init(Cursor<LabelItem> cursor, ReadableDiffSets<Integer> labelDiffSet, int labelId) {
        super.init(cursor, labelDiffSet);
        this.labelId = labelId;
        return this;
    }

    @Override
    public boolean next() {
        if (this.labelDiffSet.isAdded(this.labelId)) {
            this.label = this.labelId;
            return true;
        }
        if (this.labelDiffSet.isRemoved(this.labelId)) {
            this.label = -1;
            return false;
        }
        if (this.cursor.next()) {
            this.label = this.labelId;
            return true;
        }
        this.label = -1;
        return false;
    }
}

