/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;

public class TransactionRepresentationCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final StorageEngine storageEngine;
    private final IndexUpdatesValidator indexUpdatesValidator;

    public TransactionRepresentationCommitProcess(TransactionAppender appender, StorageEngine storageEngine, IndexUpdatesValidator indexUpdatesValidator) {
        this.appender = appender;
        this.storageEngine = storageEngine;
        this.indexUpdatesValidator = indexUpdatesValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        this.validateIndexUpdatesBeforeCommit(batch);
        long lastTxId = this.appendToLog(batch, commitEvent);
        try {
            this.applyToStore(batch, commitEvent, mode);
            long l = lastTxId;
            return l;
        }
        finally {
            this.close(batch);
        }
    }

    private void validateIndexUpdatesBeforeCommit(TransactionToApply batch) throws TransactionFailureException {
        if (batch.transactionId() == 0L) {
            if (batch.next() != null) {
                throw new UnsupportedOperationException("For the time being we only support a single previously uncommitted transaction to be committed at a time. Batching is fine when replicating transactions currently. This problem will go away when we bust the id limits");
            }
            while (batch != null) {
                batch.validatedIndexUpdates(this.validateIndexUpdates(batch.transactionRepresentation()));
                batch = batch.next();
            }
        }
    }

    private ValidatedIndexUpdates validateIndexUpdates(TransactionRepresentation transactionRepresentation) throws TransactionFailureException {
        try {
            return this.indexUpdatesValidator.validate(transactionRepresentation);
        }
        catch (Throwable e) {
            throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, e, "Validation of index updates failed", new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long appendToLog(TransactionToApply batch, CommitEvent commitEvent) throws TransactionFailureException {
        try (LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();){
            long l = this.appender.append(batch, logAppendEvent);
            return l;
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.CouldNotWriteToLog, cause, "Could not append transaction representation to log", new Object[0]);
        }
    }

    private void applyToStore(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = commitEvent.beginStoreApply();){
            this.storageEngine.apply(batch, mode);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.CouldNotCommit, cause, "Could not apply the transaction to the store after written to log", new Object[0]);
        }
    }

    private void close(TransactionToApply batch) {
        while (batch != null) {
            if (batch.commitment().markedAsCommitted()) {
                batch.commitment().publishAsClosed();
            }
            batch = batch.next();
        }
    }
}

