/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KeyReadTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.TransactionHookException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.CachingLegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.storageengine.StorageEngine;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder {
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionHooks hooks;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final StatementOperationParts operations;
    private final KernelTransactions kernelTransactions;
    private final StorageEngine storageEngine;
    private final StoreStatement storeStatement;
    private final Locks.Client locks;
    private final TransactionHeaderInformationFactory headerInformationFactory;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final Clock clock;
    private TransactionState txState;
    private LegacyIndexTransactionState legacyIndexTransactionState;
    private TransactionType transactionType = TransactionType.ANY;
    private TransactionHooks.TransactionHooksState hooksState;
    private KernelStatement currentStatement;
    private KernelTransaction.CloseListener closeListener;
    private boolean beforeHookInvoked;
    private boolean closing;
    private boolean closed;
    private boolean failure;
    private boolean success;
    private volatile boolean terminated;
    private final long startTimeMillis;
    private final long lastTransactionIdWhenStarted;
    private final TransactionEvent transactionEvent;

    public KernelTransactionImplementation(StatementOperationParts operations, SchemaWriteGuard schemaWriteGuard, Locks.Client locks, TransactionHooks hooks, ConstraintIndexCreator constraintIndexCreator, TransactionHeaderInformationFactory headerInformationFactory, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, LegacyIndexTransactionState legacyIndexTransactionState, KernelTransactions kernelTransactions, Clock clock, TransactionTracer tracer, StorageEngine storageEngine, long lastTransactionIdWhenStarted) {
        this.operations = operations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.hooks = hooks;
        this.locks = locks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.headerInformationFactory = headerInformationFactory;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.storeStatement = storageEngine.storeReadLayer().acquireStatement();
        this.storageEngine = storageEngine;
        this.legacyIndexTransactionState = new CachingLegacyIndexTransactionState(legacyIndexTransactionState);
        this.kernelTransactions = kernelTransactions;
        this.clock = clock;
        this.startTimeMillis = clock.currentTimeMillis();
        this.lastTransactionIdWhenStarted = lastTransactionIdWhenStarted;
        this.transactionEvent = tracer.beginTransaction();
    }

    @Override
    public void success() {
        this.success = true;
    }

    @Override
    public void failure() {
        this.failure = true;
    }

    @Override
    public boolean shouldBeTerminated() {
        return this.terminated;
    }

    @Override
    public void markForTermination() {
        if (!this.terminated) {
            this.failure = true;
            this.terminated = true;
            if (!this.closed) {
                this.transactionMonitor.transactionTerminated(this.hasTxStateWithChanges());
            }
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    @Override
    public KernelStatement acquireStatement() {
        this.assertTransactionOpen();
        if (this.currentStatement == null) {
            IndexReaderFactory.Caching caching = new IndexReaderFactory.Caching(this.storageEngine.indexingService());
            this.currentStatement = new KernelStatement(this, caching, this.storageEngine.labelScanStore(), this, this.locks, this.operations, this.storeStatement);
        }
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public void releaseStatement(Statement statement) {
        assert (this.currentStatement == statement);
        this.currentStatement = null;
    }

    public void upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
        this.transactionType = this.transactionType.upgradeToDataTransaction();
    }

    public void upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.doUpgradeToSchemaTransaction();
        this.transactionType = this.transactionType.upgradeToSchemaTransaction();
    }

    public void doUpgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.schemaWriteGuard.assertSchemaWritesAllowed();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                try {
                    this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                }
                catch (DropIndexFailureException e) {
                    throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                }
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.transactionMonitor.upgradeToWriteTransaction();
            this.txState = new TxState();
        }
        return this.txState;
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.legacyIndexTransactionState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void closeTransaction() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
        if (this.closeListener != null) {
            this.closeListener.notify(this.success);
        }
    }

    private void closeCurrentStatementIfAny() {
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges() || this.legacyIndexTransactionState.hasChanges();
    }

    private boolean hasDataChanges() {
        return this.hasTxStateWithChanges() && this.txState.hasDataChanges();
    }

    @Override
    public void close() throws TransactionFailureException {
        block10: {
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closeCurrentStatementIfAny();
            this.closing = true;
            try {
                if (this.failure || !this.success) {
                    this.rollback();
                    if (this.success) {
                        throw new TransactionFailureException((Status)Status.Transaction.MarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
                    }
                    break block10;
                }
                this.commit();
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionType(this.transactionType.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                }
                finally {
                    this.locks.close();
                    this.storeStatement.close();
                    this.kernelTransactions.transactionClosed(this);
                }
                throw throwable;
            }
        }
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionType(this.transactionType.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
        }
        finally {
            this.locks.close();
            this.storeStatement.close();
            this.kernelTransactions.transactionClosed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() throws TransactionFailureException {
        boolean success = false;
        try (CommitEvent commitEvent = this.transactionEvent.beginCommitEvent();){
            Collection<Command> extractedCommands;
            if (this.hasDataChanges()) {
                try {
                    this.hooksState = this.hooks.beforeCommit(this.txState, this, this.storageEngine.storeReadLayer());
                    if (this.hooksState != null && this.hooksState.failed()) {
                        TransactionHookException cause = this.hooksState.failure();
                        throw new TransactionFailureException((Status)Status.Transaction.HookFailed, (Throwable)cause, "", new Object[0]);
                    }
                }
                finally {
                    this.beforeHookInvoked = true;
                }
            }
            if (this.hasChanges() && !(extractedCommands = this.storageEngine.createCommands(this.txState, this.legacyIndexTransactionState, this.locks, this.operations, this.storeStatement, this.lastTransactionIdWhenStarted)).isEmpty()) {
                PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(extractedCommands);
                TransactionHeaderInformation headerInformation = this.headerInformationFactory.create();
                transactionRepresentation.setHeader(headerInformation.getAdditionalHeader(), headerInformation.getMasterId(), headerInformation.getAuthorId(), this.startTimeMillis, this.lastTransactionIdWhenStarted, this.clock.currentTimeMillis(), this.locks.getLockSessionId());
                this.commitProcess.commit(new TransactionToApply(transactionRepresentation), commitEvent, TransactionApplicationMode.INTERNAL);
            }
            success = true;
        }
        catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
            throw new ConstraintViolationTransactionFailureException(e.getUserMessage(new KeyReadTokenNameLookup(this.operations.keyReadOperations())), e);
        }
        finally {
            if (!success) {
                this.rollback();
            } else {
                this.afterCommit();
            }
        }
    }

    private void rollback() throws TransactionFailureException {
        block7: {
            try {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                catch (IllegalStateException | SecurityException e) {
                    throw new TransactionFailureException((Status)Status.Transaction.CouldNotRollback, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
                }
                if (this.txState == null) break block7;
                try {
                    this.txState.accept(new TxStateVisitor.Adapter(){

                        @Override
                        public void visitCreatedNode(long id) {
                            KernelTransactionImplementation.this.storageEngine.storeReadLayer().releaseNode(id);
                        }

                        @Override
                        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                            KernelTransactionImplementation.this.storageEngine.storeReadLayer().releaseRelationship(id);
                        }
                    });
                }
                catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
                    throw new IllegalStateException("Releasing locks during rollback should perform no constraints checking.", e);
                }
            }
            finally {
                this.afterRollback();
            }
        }
    }

    private void afterCommit() {
        try {
            this.closeTransaction();
            if (this.beforeHookInvoked) {
                this.hooks.afterCommit(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(true, this.hasTxStateWithChanges());
        }
    }

    private void afterRollback() {
        try {
            this.closeTransaction();
            if (this.beforeHookInvoked) {
                this.hooks.afterRollback(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(false, this.hasTxStateWithChanges());
        }
    }

    @Override
    public void registerCloseListener(KernelTransaction.CloseListener listener) {
        assert (this.closeListener == null);
        this.closeListener = listener;
    }

    public String toString() {
        return "KernelTransaction[" + this.locks.getLockSessionId() + "]";
    }

    private static enum TransactionType {
        ANY,
        DATA{

            @Override
            TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }
}

