/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.factory.SettingsResourceBundle;
import org.neo4j.kernel.configuration.AsciiDocItem;
import org.neo4j.kernel.configuration.AsciiDocListGenerator;

public class ConfigAsciiDocGenerator {
    private static final String DEFAULT_MARKER = "__DEFAULT__";
    private static final Pattern CONFIG_SETTING_PATTERN = Pattern.compile("[a-z0-9]+((\\.|_)[a-z0-9]+)+");
    private static final Pattern NUMBER_OR_IP = Pattern.compile("[0-9\\.]+");
    private static final List<String> CONFIG_NAMES_BLACKLIST = Arrays.asList("round_robin", "keep_all", "keep_last", "keep_none", "metrics.neo4j", "i.e", "e.g");
    static final String IFDEF_HTMLOUTPUT = "ifndef::nonhtmloutput[]\n";
    static final String IFDEF_NONHTMLOUTPUT = "ifdef::nonhtmloutput[]\n";
    static final String ENDIF = "endif::nonhtmloutput[]\n\n";

    public String generateDocsFor(Class<? extends SettingsResourceBundle> settingsResource) {
        return this.generateDocsFor(settingsResource.getName());
    }

    public String generateDocsFor(String settingsResource) {
        SettingsResourceBundle bundle;
        try {
            bundle = new SettingsResourceBundle(Class.forName(settingsResource));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't load settings class: ", e);
        }
        System.out.println("Generating docs for: " + settingsResource);
        String settingsResourceId = "config-" + settingsResource;
        String bundleDescription = "List of configuration settings";
        if (bundle.containsKey("description")) {
            bundleDescription = bundle.getString("description");
        }
        StringBuilder details = new StringBuilder();
        ArrayList<AsciiDocItem> beanList = new ArrayList<AsciiDocItem>();
        ArrayList<AsciiDocItem> deprecatedBeansList = new ArrayList<AsciiDocItem>();
        AsciiDocListGenerator listGenerator = new AsciiDocListGenerator(settingsResourceId, bundleDescription, true);
        AsciiDocListGenerator deprecatedBeanslistGenerator = new AsciiDocListGenerator(settingsResourceId + "-deprecated", "Deprecated settings", true);
        ArrayList<String> keys = new ArrayList<String>(((ResourceBundle)bundle).keySet());
        Collections.sort(keys);
        for (String property : keys) {
            String name;
            String internalKey;
            if (!property.endsWith(".description") || bundle.containsKey(internalKey = (name = property.substring(0, property.lastIndexOf("."))) + ".internal")) continue;
            String id = "config_" + name;
            String descriptionKey = name + ".description";
            String description = this.linkifyConfigSettings(bundle.getString(descriptionKey), name, false);
            AsciiDocItem beanSummary = new AsciiDocItem(id, name, description);
            String deprecatedKey = name + ".deprecated";
            String obsoletedKey = name + ".obsoleted";
            if (bundle.containsKey(deprecatedKey) || bundle.containsKey(obsoletedKey)) {
                deprecatedBeansList.add(beanSummary);
            } else {
                beanList.add(beanSummary);
            }
            details.append(this.addDocsForOneSetting(bundle, id, name, description, false));
            details.append(this.addDocsForOneSetting(bundle, id, name, description, true));
        }
        return listGenerator.generateListAndTableCombo(beanList) + (deprecatedBeansList.isEmpty() ? "" : deprecatedBeanslistGenerator.generateListAndTableCombo(deprecatedBeansList)) + details.toString();
    }

    private String addDocsForOneSetting(ResourceBundle bundle, String id, String name, String description, boolean pdfOutput) {
        String mandatorykey;
        String defaultValue;
        String defaultKey;
        StringBuilder table = new StringBuilder(1024);
        if (pdfOutput) {
            table.append(IFDEF_NONHTMLOUTPUT);
        } else {
            table.append(IFDEF_HTMLOUTPUT);
        }
        String monospacedName = "`" + name + "`";
        table.append("[[").append(id).append("]]\n").append('.').append(name).append('\n').append("[cols=\"<1h,<4\"]\n").append("|===\n");
        table.append("|Description a|");
        this.addWithDotAtEndAsNeeded(table, description);
        String validationKey = name + ".validationmessage";
        if (bundle.containsKey(validationKey)) {
            String validation = bundle.getString(validationKey);
            table.append("|Valid values a|");
            this.addWithDotAtEndAsNeeded(table, this.linkifyConfigSettings(validation, name, pdfOutput));
        }
        if (bundle.containsKey(defaultKey = name + ".default") && !(defaultValue = bundle.getString(defaultKey)).equals(DEFAULT_MARKER)) {
            table.append("|Default value m|").append(defaultValue).append('\n');
        }
        if (bundle.containsKey(mandatorykey = name + ".mandatory")) {
            table.append("|Mandatory a|");
            this.addWithDotAtEndAsNeeded(table, bundle.getString(mandatorykey).replace(name, monospacedName));
        }
        String deprecatedKey = name + ".deprecated";
        String obsoletedKey = name + ".obsoleted";
        if (bundle.containsKey(deprecatedKey) || bundle.containsKey(obsoletedKey)) {
            table.append("|Deprecated a|");
            if (bundle.containsKey(obsoletedKey)) {
                this.addWithDotAtEndAsNeeded(table, this.linkifyConfigSettings(bundle.getString(obsoletedKey), name, pdfOutput));
            } else {
                this.addWithDotAtEndAsNeeded(table, this.linkifyConfigSettings(bundle.getString(deprecatedKey), name, pdfOutput));
            }
        }
        table.append("|===\n").append(ENDIF);
        return table.toString();
    }

    private void addWithDotAtEndAsNeeded(StringBuilder sb, String message) {
        sb.append(message);
        if (!message.endsWith(".") && !message.endsWith(". ")) {
            sb.append('.');
        }
        sb.append('\n');
    }

    private String linkifyConfigSettings(String text, String nameToNotLink, boolean pdfOutput) {
        Matcher matcher = CONFIG_SETTING_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer(256);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.endsWith(".log")) {
                match = "_" + match + "_";
            } else if (match.equals(nameToNotLink)) {
                match = "`" + match + "`";
            } else if (!CONFIG_NAMES_BLACKLIST.contains(match) && !NUMBER_OR_IP.matcher(match).matches()) {
                match = pdfOutput ? "`" + match + "`" : this.makeConfigXref(match);
            }
            matcher.appendReplacement(result, match);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String makeConfigXref(String settingName) {
        return "+<<config_" + settingName + "," + settingName + ">>+";
    }
}

