/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;

public interface TxStateVisitor
extends AutoCloseable {
    public static final TxStateVisitor EMPTY = new Adapter();

    public void visitCreatedNode(long var1);

    public void visitDeletedNode(long var1);

    public void visitCreatedRelationship(long var1, int var3, long var4, long var6) throws ConstraintValidationKernelException;

    public void visitDeletedRelationship(long var1);

    public void visitNodePropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5) throws ConstraintValidationKernelException;

    public void visitNodeRelationshipChanges(long var1, RelationshipChangesForNode var3, RelationshipChangesForNode var4);

    public void visitRelPropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5) throws ConstraintValidationKernelException;

    public void visitGraphPropertyChanges(Iterator<DefinedProperty> var1, Iterator<DefinedProperty> var2, Iterator<Integer> var3);

    public void visitNodeLabelChanges(long var1, Set<Integer> var3, Set<Integer> var4) throws ConstraintValidationKernelException;

    public void visitAddedIndex(IndexDescriptor var1, boolean var2);

    public void visitRemovedIndex(IndexDescriptor var1, boolean var2);

    public void visitAddedUniquePropertyConstraint(UniquenessConstraint var1);

    public void visitRemovedUniquePropertyConstraint(UniquenessConstraint var1);

    public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint var1) throws CreateConstraintFailureException;

    public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint var1);

    public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint var1) throws CreateConstraintFailureException;

    public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint var1);

    public void visitCreatedLabelToken(String var1, int var2);

    public void visitCreatedPropertyKeyToken(String var1, int var2);

    public void visitCreatedRelationshipTypeToken(String var1, int var2);

    public void visitCreatedNodeLegacyIndex(String var1, Map<String, String> var2);

    public void visitCreatedRelationshipLegacyIndex(String var1, Map<String, String> var2);

    public void visitCreatedProcedure(ProcedureDescriptor var1);

    public void visitDroppedProcedure(ProcedureDescriptor var1);

    @Override
    public void close();

    public static class Delegator
    implements TxStateVisitor {
        private final TxStateVisitor actual;

        public Delegator(TxStateVisitor actual) {
            assert (actual != null);
            this.actual = actual;
        }

        @Override
        public void visitCreatedNode(long id) {
            this.actual.visitCreatedNode(id);
        }

        @Override
        public void visitDeletedNode(long id) {
            this.actual.visitDeletedNode(id);
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
            this.actual.visitCreatedRelationship(id, type, startNode, endNode);
        }

        @Override
        public void visitDeletedRelationship(long id) {
            this.actual.visitDeletedRelationship(id);
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
            this.actual.visitNodePropertyChanges(id, added, changed, removed);
        }

        @Override
        public void visitNodeRelationshipChanges(long id, RelationshipChangesForNode added, RelationshipChangesForNode removed) {
            this.actual.visitNodeRelationshipChanges(id, added, removed);
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
            this.actual.visitRelPropertyChanges(id, added, changed, removed);
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            this.actual.visitGraphPropertyChanges(added, changed, removed);
        }

        @Override
        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
            this.actual.visitNodeLabelChanges(id, added, removed);
        }

        @Override
        public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            this.actual.visitAddedIndex(element, isConstraintIndex);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            this.actual.visitRemovedIndex(element, isConstraintIndex);
        }

        @Override
        public void visitAddedUniquePropertyConstraint(UniquenessConstraint element) {
            this.actual.visitAddedUniquePropertyConstraint(element);
        }

        @Override
        public void visitRemovedUniquePropertyConstraint(UniquenessConstraint element) {
            this.actual.visitRemovedUniquePropertyConstraint(element);
        }

        @Override
        public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) throws CreateConstraintFailureException {
            this.actual.visitAddedNodePropertyExistenceConstraint(element);
        }

        @Override
        public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) {
            this.actual.visitRemovedNodePropertyExistenceConstraint(element);
        }

        @Override
        public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) throws CreateConstraintFailureException {
            this.actual.visitAddedRelationshipPropertyExistenceConstraint(element);
        }

        @Override
        public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) {
            this.actual.visitRemovedRelationshipPropertyExistenceConstraint(element);
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
            this.actual.visitCreatedLabelToken(name, id);
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
            this.actual.visitCreatedPropertyKeyToken(name, id);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
            this.actual.visitCreatedRelationshipTypeToken(name, id);
        }

        @Override
        public void visitCreatedNodeLegacyIndex(String name, Map<String, String> config) {
            this.actual.visitCreatedNodeLegacyIndex(name, config);
        }

        @Override
        public void visitCreatedRelationshipLegacyIndex(String name, Map<String, String> config) {
            this.actual.visitCreatedRelationshipLegacyIndex(name, config);
        }

        @Override
        public void visitCreatedProcedure(ProcedureDescriptor procedureDescriptor) {
            this.actual.visitCreatedProcedure(procedureDescriptor);
        }

        @Override
        public void visitDroppedProcedure(ProcedureDescriptor procedureDescriptor) {
            this.actual.visitDroppedProcedure(procedureDescriptor);
        }

        @Override
        public void close() {
            this.actual.close();
        }
    }

    public static class Adapter
    implements TxStateVisitor {
        @Override
        public void visitCreatedNode(long id) {
        }

        @Override
        public void visitDeletedNode(long id) {
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
        }

        @Override
        public void visitDeletedRelationship(long id) {
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
        }

        @Override
        public void visitNodeRelationshipChanges(long id, RelationshipChangesForNode added, RelationshipChangesForNode removed) {
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
        }

        @Override
        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
        }

        @Override
        public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
        }

        @Override
        public void visitAddedUniquePropertyConstraint(UniquenessConstraint element) {
        }

        @Override
        public void visitRemovedUniquePropertyConstraint(UniquenessConstraint element) {
        }

        @Override
        public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) throws CreateConstraintFailureException {
        }

        @Override
        public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) {
        }

        @Override
        public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) throws CreateConstraintFailureException {
        }

        @Override
        public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) {
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
        }

        @Override
        public void visitCreatedNodeLegacyIndex(String name, Map<String, String> config) {
        }

        @Override
        public void visitCreatedRelationshipLegacyIndex(String name, Map<String, String> config) {
        }

        @Override
        public void visitCreatedProcedure(ProcedureDescriptor procedureDescriptor) {
        }

        @Override
        public void visitDroppedProcedure(ProcedureDescriptor procedureDescriptor) {
        }

        @Override
        public void close() {
        }
    }
}

