/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.impl.locking.Locks;

public class Exceptions {
    private static final String UNEXPECTED_MESSAGE = "Unexpected Exception";
    private static final Field THROWABLE_MESSAGE_FIELD;

    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    public static <T extends Throwable> T withSuppressed(T exception, Throwable ... suppressed) {
        if (suppressed != null) {
            for (Throwable s : suppressed) {
                exception.addSuppressed(s);
            }
        }
        return exception;
    }

    public static RuntimeException launderedException(Throwable exception) {
        return Exceptions.launderedException(UNEXPECTED_MESSAGE, exception);
    }

    public static RuntimeException launderedException(String messageForUnexpected, Throwable exception) {
        return Exceptions.launderedException(RuntimeException.class, messageForUnexpected, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, Throwable exception) {
        return Exceptions.launderedException(type, UNEXPECTED_MESSAGE, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, String messageForUnexpected, Throwable exception) {
        if (type.isInstance(exception)) {
            return (T)((Throwable)type.cast(exception));
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InvocationTargetException) {
            return Exceptions.launderedException(type, messageForUnexpected, ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(messageForUnexpected, exception);
    }

    public static Throwable peel(Throwable exception, Predicate<Throwable> toPeel) {
        while (exception != null && toPeel.test(exception)) {
            exception = exception.getCause();
        }
        return exception;
    }

    public static Predicate<Throwable> exceptionsWithMessageContaining(String message) {
        return item -> item.getMessage() != null && item.getMessage().contains(message);
    }

    private Exceptions() {
    }

    public static Throwable rootCause(Throwable caughtException) {
        if (null == caughtException) {
            throw new IllegalArgumentException("Cannot obtain rootCause from (null)");
        }
        Throwable root = caughtException;
        for (Throwable cause = root.getCause(); null != cause; cause = cause.getCause()) {
            root = cause;
        }
        return root;
    }

    public static String stringify(Throwable cause) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream target = new PrintStream((OutputStream)bytes, true, StandardCharsets.UTF_8.name());
            cause.printStackTrace(target);
            target.flush();
            return bytes.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            cause.printStackTrace(System.err);
            return "[ERROR: Unable to serialize stacktrace, UTF-8 not supported.]";
        }
    }

    public static String stringify(Thread thread, StackTraceElement[] elements) {
        StringBuilder builder = new StringBuilder("\"" + thread.getName() + "\"" + (thread.isDaemon() ? " daemon" : "") + " prio=" + thread.getPriority() + " tid=" + thread.getId() + " " + thread.getState().name().toLowerCase() + "\n");
        builder.append("   " + Thread.State.class.getName() + ": " + thread.getState().name().toUpperCase() + "\n");
        for (StackTraceElement element : elements) {
            builder.append("      at " + element.getClassName() + "." + element.getMethodName());
            if (element.isNativeMethod()) {
                builder.append("(Native method)");
            } else if (element.getFileName() == null) {
                builder.append("(Unknown source)");
            } else {
                builder.append("(" + element.getFileName() + ":" + element.getLineNumber() + ")");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static boolean contains(Throwable cause, String containsMessage, Class ... anyOfTheseClasses) {
        Predicate anyOfClasses = Predicates.instanceOfAny((Class[])anyOfTheseClasses);
        return Exceptions.contains(cause, (Throwable item) -> item.getMessage() != null && item.getMessage().contains(containsMessage) && anyOfClasses.test(item));
    }

    public static boolean contains(Throwable cause, Class ... anyOfTheseClasses) {
        return Exceptions.contains(cause, Predicates.instanceOfAny((Class[])anyOfTheseClasses));
    }

    public static boolean contains(Throwable cause, Predicate<Throwable> toLookFor) {
        while (cause != null) {
            if (toLookFor.test(cause)) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    public static <E extends Throwable> E combine(E first, E second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        Object current = first;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        current.initCause(second);
        return first;
    }

    public static <T extends Throwable> T withMessage(T cause, String message) {
        try {
            THROWABLE_MESSAGE_FIELD.set(cause, message);
            return cause;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static Predicate<StackTraceElement> classImplementingInterface(Class<Locks.Client> cls) {
        return item -> {
            try {
                for (Class<?> interfaceClass : Class.forName(item.getClassName()).getInterfaces()) {
                    if (!interfaceClass.equals(cls)) continue;
                    return true;
                }
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        };
    }

    @Deprecated
    public static boolean containsStackTraceElement(Throwable cause, Predicate<StackTraceElement> predicate) {
        return Exceptions.contains(cause, (Throwable item) -> {
            for (StackTraceElement element : item.getStackTrace()) {
                if (!predicate.test(element)) continue;
                return true;
            }
            return false;
        });
    }

    @Deprecated
    public static Predicate<StackTraceElement> forMethod(String name) {
        return item -> item.getMethodName().equals(name);
    }

    public static String briefOneLineStackTraceInformation(Predicate<StackTraceElement> toInclude) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!toInclude.test(element)) continue;
            builder.append(builder.length() > 0 ? "," : "").append(Exceptions.simpleClassName(element.getClassName()) + "#" + element.getMethodName());
        }
        return builder.toString();
    }

    private static String simpleClassName(String className) {
        return className.substring(className.lastIndexOf(46));
    }

    static {
        try {
            THROWABLE_MESSAGE_FIELD = Throwable.class.getDeclaredField("detailMessage");
            THROWABLE_MESSAGE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new LinkageError("Could not get Throwable message field", e);
        }
    }
}

