/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Recovery
extends LifecycleAdapter {
    private final SPI spi;
    private final Monitor monitor;
    private boolean recoveredLog = false;

    public Recovery(SPI spi, Monitor monitor) {
        this.spi = spi;
        this.monitor = monitor;
    }

    @Override
    public void init() throws Throwable {
        LogPosition recoveryPosition = this.spi.getPositionToRecoverFrom();
        if (LogPosition.UNSPECIFIED.equals(recoveryPosition)) {
            return;
        }
        Iterator<LogVersionedStoreChannel> logFiles = this.spi.getLogFiles(recoveryPosition.getLogVersion());
        this.monitor.recoveryRequired(recoveryPosition);
        this.spi.recoveryRequired();
        Visitor<LogVersionedStoreChannel, IOException> recoverer = this.spi.getRecoverer();
        while (logFiles.hasNext()) {
            LogVersionedStoreChannel toRecover = logFiles.next();
            Throwable throwable = null;
            try {
                toRecover.position(recoveryPosition.getByteOffset());
                recoverer.visit(toRecover);
                recoveryPosition = LogPosition.start(recoveryPosition.getLogVersion() + 1L);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (toRecover == null) continue;
                if (throwable != null) {
                    try {
                        toRecover.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                toRecover.close();
            }
        }
        this.recoveredLog = true;
        this.monitor.logRecovered(recoveryPosition);
        this.spi.forceEverything();
    }

    @Override
    public void start() throws Throwable {
        if (this.recoveredLog) {
            this.spi.forceEverything();
            this.monitor.recoveryCompleted();
        }
    }

    public static interface SPI {
        public void forceEverything();

        public Visitor<LogVersionedStoreChannel, IOException> getRecoverer();

        public Iterator<LogVersionedStoreChannel> getLogFiles(long var1) throws IOException;

        public LogPosition getPositionToRecoverFrom() throws IOException;

        public void recoveryRequired();
    }

    public static interface Monitor {
        public void recoveryRequired(LogPosition var1);

        public void logRecovered(LogPosition var1);

        public void recoveryCompleted();
    }
}

