/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.traversal.BranchOrderingPolicies;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.InitialStateFactory;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Factory;
import org.neo4j.kernel.StandardExpander;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.DefaultTraverser;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraverserIterator;
import org.neo4j.kernel.impl.traversal.MultiEvaluator;
import org.neo4j.kernel.impl.traversal.SortingTraverserIterator;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

public final class MonoDirectionalTraversalDescription
implements TraversalDescription {
    static final Supplier<Resource> NO_STATEMENT = new Supplier<Resource>(){

        public Resource get() {
            return Resource.EMPTY;
        }
    };
    final PathExpander expander;
    final InitialBranchState initialState;
    final Supplier<? extends Resource> statementSupplier;
    final UniquenessFactory uniqueness;
    final Object uniquenessParameter;
    final PathEvaluator evaluator;
    final BranchOrderingPolicy branchOrdering;
    final Comparator<? super Path> sorting;
    final Collection<Node> endNodes;

    public MonoDirectionalTraversalDescription() {
        this(NO_STATEMENT);
    }

    public MonoDirectionalTraversalDescription(Supplier<? extends Resource> statementProvider) {
        this(PathExpanders.allTypesAndDirections(), Uniqueness.NODE_GLOBAL, null, Evaluators.all(), InitialBranchState.NO_STATE, BranchOrderingPolicies.PREORDER_DEPTH_FIRST, null, null, statementProvider);
    }

    private MonoDirectionalTraversalDescription(PathExpander expander, UniquenessFactory uniqueness, Object uniquenessParameter, PathEvaluator evaluator, InitialBranchState initialState, BranchOrderingPolicy branchOrdering, Comparator<? super Path> sorting, Collection<Node> endNodes, Supplier<? extends Resource> statementSupplier) {
        this.expander = expander;
        this.uniqueness = uniqueness;
        this.uniquenessParameter = uniquenessParameter;
        this.evaluator = evaluator;
        this.branchOrdering = branchOrdering;
        this.sorting = sorting;
        this.endNodes = endNodes;
        this.initialState = initialState;
        this.statementSupplier = statementSupplier;
    }

    @Override
    public Traverser traverse(Node startNode) {
        return this.traverse(Collections.singletonList(startNode));
    }

    @Override
    public Traverser traverse(Node ... startNodes) {
        return this.traverse(Arrays.asList(startNodes));
    }

    @Override
    public Traverser traverse(final Iterable<Node> iterableStartNodes) {
        return new DefaultTraverser(new Factory<TraverserIterator>(){

            public TraverserIterator newInstance() {
                Resource statement = (Resource)MonoDirectionalTraversalDescription.this.statementSupplier.get();
                MonoDirectionalTraverserIterator iterator = new MonoDirectionalTraverserIterator(statement, MonoDirectionalTraversalDescription.this.uniqueness.create(MonoDirectionalTraversalDescription.this.uniquenessParameter), MonoDirectionalTraversalDescription.this.expander, MonoDirectionalTraversalDescription.this.branchOrdering, MonoDirectionalTraversalDescription.this.evaluator, iterableStartNodes, MonoDirectionalTraversalDescription.this.initialState, MonoDirectionalTraversalDescription.this.uniqueness);
                return MonoDirectionalTraversalDescription.this.sorting != null ? new SortingTraverserIterator(statement, MonoDirectionalTraversalDescription.this.sorting, iterator) : iterator;
            }
        });
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness) {
        return new MonoDirectionalTraversalDescription(this.expander, uniqueness, null, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public TraversalDescription uniqueness(UniquenessFactory uniqueness, Object parameter) {
        if (this.uniqueness == uniqueness && (this.uniquenessParameter == null ? parameter == null : this.uniquenessParameter.equals(parameter))) {
            return this;
        }
        return new MonoDirectionalTraversalDescription(this.expander, uniqueness, parameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public TraversalDescription evaluator(Evaluator evaluator) {
        return this.evaluator(new Evaluator.AsPathEvaluator(evaluator));
    }

    @Override
    public TraversalDescription evaluator(PathEvaluator evaluator) {
        if (this.evaluator == evaluator) {
            return this;
        }
        MonoDirectionalTraversalDescription.nullCheck(evaluator, Evaluator.class, "RETURN_ALL");
        return new MonoDirectionalTraversalDescription(this.expander, this.uniqueness, this.uniquenessParameter, MonoDirectionalTraversalDescription.addEvaluator(this.evaluator, evaluator), this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    protected static PathEvaluator addEvaluator(PathEvaluator existing, PathEvaluator toAdd) {
        if (existing instanceof MultiEvaluator) {
            return ((MultiEvaluator)existing).add(toAdd);
        }
        return existing == Evaluators.all() ? toAdd : new MultiEvaluator(existing, toAdd);
    }

    protected static <T> void nullCheck(T parameter, Class<T> parameterType, String defaultName) {
        if (parameter == null) {
            String typeName = parameterType.getSimpleName();
            throw new IllegalArgumentException(typeName + " may not be null, use " + typeName + "." + defaultName + " instead.");
        }
    }

    @Override
    public TraversalDescription order(BranchOrderingPolicy order) {
        if (this.branchOrdering == order) {
            return this;
        }
        return new MonoDirectionalTraversalDescription(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, order, this.sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public TraversalDescription depthFirst() {
        return this.order(BranchOrderingPolicies.PREORDER_DEPTH_FIRST);
    }

    @Override
    public TraversalDescription breadthFirst() {
        return this.order(BranchOrderingPolicies.PREORDER_BREADTH_FIRST);
    }

    @Override
    public TraversalDescription relationships(RelationshipType type) {
        return this.relationships(type, Direction.BOTH);
    }

    @Override
    public TraversalDescription relationships(RelationshipType type, Direction direction) {
        if (this.expander instanceof Expander) {
            return this.expand(((Expander)((Object)this.expander)).add(type, direction));
        }
        throw new IllegalStateException("The current expander cannot be added to");
    }

    @Override
    public TraversalDescription expand(RelationshipExpander expander) {
        return this.expand(StandardExpander.toPathExpander(expander));
    }

    @Override
    public TraversalDescription expand(PathExpander<?> expander) {
        if (expander.equals(this.expander)) {
            return this;
        }
        return new MonoDirectionalTraversalDescription(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public <STATE> TraversalDescription expand(PathExpander<STATE> expander, InitialBranchState<STATE> initialState) {
        return new MonoDirectionalTraversalDescription(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, initialState, this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public <STATE> TraversalDescription expand(PathExpander<STATE> expander, InitialStateFactory<STATE> initialState) {
        return new MonoDirectionalTraversalDescription(expander, this.uniqueness, this.uniquenessParameter, this.evaluator, new InitialStateFactory.AsInitialBranchState<STATE>(initialState), this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public TraversalDescription sort(Comparator<? super Path> sorting) {
        return new MonoDirectionalTraversalDescription(this.expander, this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState, this.branchOrdering, sorting, this.endNodes, this.statementSupplier);
    }

    @Override
    public TraversalDescription reverse() {
        return new MonoDirectionalTraversalDescription(this.expander.reverse(), this.uniqueness, this.uniquenessParameter, this.evaluator, this.initialState.reverse(), this.branchOrdering, this.sorting, this.endNodes, this.statementSupplier);
    }
}

