/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicateCluster;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexedConflictsResolver;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.NonIndexedConflictResolver;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class PropertyDeduplicator {
    private final FileSystemAbstraction fileSystem;
    private final File workingDir;
    private final PageCache pageCache;
    private final SchemaIndexProvider schemaIndexProvider;
    private final PrimitiveIntObjectMap<Long> seenPropertyKeys;
    private final PrimitiveIntObjectMap<DuplicateCluster> localDuplicateClusters;

    public PropertyDeduplicator(FileSystemAbstraction fileSystem, File workingDir, PageCache pageCache, SchemaIndexProvider schemaIndexProvider) {
        this.fileSystem = fileSystem;
        this.workingDir = workingDir;
        this.pageCache = pageCache;
        this.schemaIndexProvider = schemaIndexProvider;
        this.seenPropertyKeys = Primitive.intObjectMap();
        this.localDuplicateClusters = Primitive.intObjectMap();
    }

    public void deduplicateProperties() throws IOException {
        StoreFactory storeFactory = new StoreFactory(this.fileSystem, this.workingDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = storeFactory.openNeoStores(StoreType.PROPERTY, StoreType.NODE, StoreType.SCHEMA);){
            PropertyStore propertyStore = neoStores.getPropertyStore();
            NodeStore nodeStore = neoStores.getNodeStore();
            SchemaStore schemaStore = neoStores.getSchemaStore();
            PrimitiveLongObjectMap<List<DuplicateCluster>> duplicateClusters = this.collectConflictingProperties(propertyStore);
            this.resolveConflicts(duplicateClusters, propertyStore, nodeStore, schemaStore);
        }
    }

    private PrimitiveLongObjectMap<List<DuplicateCluster>> collectConflictingProperties(PropertyStore store) {
        final PrimitiveLongObjectMap duplicateClusters = Primitive.longObjectMap();
        long highId = store.getHighId();
        for (long headRecordId = 0L; headRecordId < highId; ++headRecordId) {
            PropertyRecord record = store.forceGetRecord(headRecordId);
            if (!record.inUse() || record.getPrevProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) continue;
            long propertyId = headRecordId;
            while (propertyId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord propertyBlocks = record = store.getRecord(propertyId);
                this.scanForDuplicates(propertyId, propertyBlocks);
                propertyId = record.getNextProp();
            }
            final long localHeadRecordId = headRecordId;
            this.localDuplicateClusters.visitEntries((PrimitiveIntObjectVisitor)new PrimitiveIntObjectVisitor<DuplicateCluster, RuntimeException>(){

                public boolean visited(int key, DuplicateCluster duplicateCluster) {
                    ArrayList<DuplicateCluster> clusters = (ArrayList<DuplicateCluster>)duplicateClusters.get(localHeadRecordId);
                    if (clusters == null) {
                        clusters = new ArrayList<DuplicateCluster>();
                        duplicateClusters.put(localHeadRecordId, clusters);
                    }
                    clusters.add(duplicateCluster);
                    return false;
                }
            });
            this.seenPropertyKeys.clear();
            this.localDuplicateClusters.clear();
        }
        return duplicateClusters;
    }

    private void scanForDuplicates(long propertyId, Iterable<PropertyBlock> propertyBlocks) {
        for (PropertyBlock block : propertyBlocks) {
            int propertyKeyId = block.getKeyIndexId();
            if (this.seenPropertyKeys.containsKey(propertyKeyId)) {
                DuplicateCluster cluster = (DuplicateCluster)this.localDuplicateClusters.get(propertyKeyId);
                if (cluster == null) {
                    cluster = new DuplicateCluster(propertyKeyId);
                    this.localDuplicateClusters.put(propertyKeyId, (Object)cluster);
                }
                cluster.add((Long)this.seenPropertyKeys.get(propertyKeyId));
                cluster.add(propertyId);
                continue;
            }
            this.seenPropertyKeys.put(propertyKeyId, (Object)propertyId);
        }
    }

    private void resolveConflicts(PrimitiveLongObjectMap<List<DuplicateCluster>> duplicateClusters, PropertyStore propertyStore, NodeStore nodeStore, SchemaStore schemaStore) throws IOException {
        if (duplicateClusters.isEmpty()) {
            return;
        }
        try (IndexLookup indexLookup = new IndexLookup(schemaStore, this.schemaIndexProvider);
             IndexedConflictsResolver indexedConflictsResolver = new IndexedConflictsResolver(duplicateClusters, indexLookup, nodeStore, propertyStore);){
            if (indexLookup.hasAnyIndexes()) {
                nodeStore.scanAllRecords(indexedConflictsResolver);
            }
        }
        PropertyKeyTokenStore keyTokenStore = propertyStore.getPropertyKeyTokenStore();
        NonIndexedConflictResolver resolver = new NonIndexedConflictResolver(keyTokenStore, propertyStore);
        duplicateClusters.visitEntries((PrimitiveLongObjectVisitor)resolver);
    }
}

