/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.logging.LogProvider;

public abstract class AbstractStore
extends CommonAbstractStore {
    public AbstractStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider) {
        super(fileName, conf, idType, idGeneratorFactory, pageCache, logProvider);
    }

    @Override
    public abstract int getRecordSize();

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
    }

    @Override
    protected boolean isInUse(byte inUseByte) {
        return (inUseByte & 1) == Record.IN_USE.intValue();
    }

    @Override
    protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        ByteBuffer headerRecord = this.createHeaderRecord();
        if (headerRecord != null) {
            try (PageCursor pageCursor = file.io(0L, 2);){
                if (pageCursor.next()) {
                    do {
                        pageCursor.setOffset(0);
                        pageCursor.putBytes(headerRecord.array());
                    } while (pageCursor.shouldRetry());
                }
            }
        }
        File idFileName = new File(this.storageFileName.getPath() + ".id");
        this.idGeneratorFactory.create(idFileName, 0L, true);
        if (headerRecord != null) {
            IdGenerator idGenerator = this.idGeneratorFactory.open(idFileName, 1, this.idType, 0L);
            this.initialiseNewIdGenerator(idGenerator);
            idGenerator.close();
        }
    }

    protected void initialiseNewIdGenerator(IdGenerator idGenerator) {
        idGenerator.nextId();
    }

    protected ByteBuffer createHeaderRecord() {
        return null;
    }
}

