/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Factory;
import org.neo4j.function.Function;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexPopulationProgress;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class DiskLayer
implements StoreReadLayer {
    private static final Function<PropertyConstraintRule, PropertyConstraint> RULE_TO_CONSTRAINT = new Function<PropertyConstraintRule, PropertyConstraint>(){

        public PropertyConstraint apply(PropertyConstraintRule rule) {
            return rule.toConstraint();
        }
    };
    private static final Function<NodePropertyConstraintRule, NodePropertyConstraint> NODE_RULE_TO_CONSTRAINT = new Function<NodePropertyConstraintRule, NodePropertyConstraint>(){

        public NodePropertyConstraint apply(NodePropertyConstraintRule rule) {
            return rule.toConstraint();
        }
    };
    private static final Function<RelationshipPropertyConstraintRule, RelationshipPropertyConstraint> REL_RULE_TO_CONSTRAINT = new Function<RelationshipPropertyConstraintRule, RelationshipPropertyConstraint>(){

        public RelationshipPropertyConstraint apply(RelationshipPropertyConstraintRule rule) {
            return rule.toConstraint();
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final NeoStores neoStores;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final SchemaStorage schemaStorage;
    private final CountsAccessor counts;
    private final PropertyLoader propertyLoader;
    private final Factory<StoreStatement> statementProvider;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        public boolean test(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        public boolean test(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public DiskLayer(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, NeoStores neoStores, IndexingService indexService, Factory<StoreStatement> statementProvider) {
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStores = neoStores;
        this.statementProvider = statementProvider;
        this.nodeStore = this.neoStores.getNodeStore();
        this.relationshipStore = this.neoStores.getRelationshipStore();
        this.counts = neoStores.getCounts();
        this.propertyLoader = new PropertyLoader(neoStores);
    }

    @Override
    public StoreStatement acquireStatement() {
        return (StoreStatement)this.statementProvider.newInstance();
    }

    @Override
    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return state.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        IndexReader reader = state.getIndexReader(index);
        return reader.seek(value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromInclusiveNumericIndexRangeSeek(KernelStatement statement, IndexDescriptor index, Number lower, Number upper) throws IndexNotFoundKernelException {
        IndexReader reader = statement.getIndexReader(index);
        return reader.rangeSeekByNumberInclusive(lower, upper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement statement, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        IndexReader reader = statement.getIndexReader(index);
        return reader.rangeSeekByString(lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        IndexReader reader = state.getIndexReader(index);
        return reader.rangeSeekByPrefix(prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        IndexReader reader = state.getIndexReader(index);
        return reader.scan();
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKey) {
        return DiskLayer.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            public boolean test(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStores.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            public IndexDescriptor apply(SchemaRule from) {
                return DiskLayer.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public IndexRule indexRule(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getState();
    }

    @Override
    public IndexPopulationProgress indexGetPopulationProgress(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getIndexPopulationProgress();
    }

    @Override
    public long indexSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        Register.DoubleLongRegister result = this.indexService.indexUpdatesAndSize(descriptor);
        return result.readSecond();
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public Iterator<ProcedureDescriptor> proceduresGetAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProcedureDescriptor procedureGet(ProcedureSignature.ProcedureName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getPopulationFailure().asString();
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(int labelId, final int propertyKeyId) {
        return this.schemaStorage.schemaRulesForNodes(NODE_RULE_TO_CONSTRAINT, NodePropertyConstraintRule.class, labelId, new Predicate<NodePropertyConstraintRule>(){

            public boolean test(NodePropertyConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaStorage.schemaRulesForNodes(NODE_RULE_TO_CONSTRAINT, NodePropertyConstraintRule.class, labelId, Predicates.alwaysTrue());
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(int typeId, final int propertyKeyId) {
        return this.schemaStorage.schemaRulesForRelationships(REL_RULE_TO_CONSTRAINT, RelationshipPropertyConstraintRule.class, typeId, new Predicate<RelationshipPropertyConstraintRule>(){

            public boolean test(RelationshipPropertyConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(int typeId) {
        return this.schemaStorage.schemaRulesForRelationships(REL_RULE_TO_CONSTRAINT, RelationshipPropertyConstraintRule.class, typeId, Predicates.alwaysTrue());
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll() {
        return this.schemaStorage.schemaRules(RULE_TO_CONSTRAINT, PropertyConstraintRule.class);
    }

    @Override
    public PrimitiveLongResourceIterator nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor descriptor, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        IndexReader reader = state.getFreshIndexReader(descriptor);
        return IteratorUtil.resourceIterator(reader.seek(value), (Resource)reader);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        return new PropertyKeyIdIterator(this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver()));
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        return this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver());
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((RelationshipTypeToken)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipRecord record;
        try {
            record = this.relationshipStore.getRecord(relationshipId);
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public long highestNodeIdInUse() {
        return this.nodeStore.getHighestPossibleIdInUse();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
            private long highId;
            private long currentId;
            private final NodeRecord reusableNodeRecord;
            {
                this.highId = DiskLayer.this.nodeStore.getHighestPossibleIdInUse();
                this.reusableNodeRecord = new NodeRecord(-1L);
            }

            /*
             * Unable to fully structure code
             */
            protected boolean fetchNext() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            record = DiskLayer.access$100(DiskLayer.this).loadRecord(this.currentId, this.reusableNodeRecord);
                            if (record == null || !record.inUse()) ** GOTO lbl-1000
                            var2_3 = this.next(record.getId());
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = DiskLayer.access$100(DiskLayer.this).getHighestPossibleIdInUse();
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return false;
            }
        };
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return new RelationshipIterator.BaseIterator(){
            private long highId;
            private long currentId;
            private final RelationshipRecord reusableRecord;
            {
                this.highId = DiskLayer.this.relationshipStore.getHighestPossibleIdInUse();
                this.reusableRecord = new RelationshipRecord(-1L);
            }

            /*
             * Unable to fully structure code
             */
            protected boolean fetchNext() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            if (!DiskLayer.access$200(DiskLayer.this).fillRecord(this.currentId, this.reusableRecord, RecordLoad.CHECK) || !this.reusableRecord.inUse()) ** GOTO lbl-1000
                            var1_2 = this.next(this.reusableRecord.getId());
                            return var1_2;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = DiskLayer.access$200(DiskLayer.this).getHighestPossibleIdInUse();
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return false;
            }

            @Override
            public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
                visitor.visit(relationshipId, this.reusableRecord.getType(), this.reusableRecord.getFirstNode(), this.reusableRecord.getSecondNode());
                return false;
            }
        };
    }

    @Override
    public long reserveNode() {
        return this.nodeStore.nextId();
    }

    @Override
    public long reserveRelationship() {
        return this.relationshipStore.nextId();
    }

    @Override
    public void releaseNode(long id) {
        this.nodeStore.freeId(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.relationshipStore.freeId(id);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }
}

