/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;

public class RecoveryIndexingUpdatesValidator
implements IndexUpdatesValidator,
ValidatedIndexUpdates {
    private final NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();
    private final PrimitiveLongVisitor<RuntimeException> updatedNodeVisitor;

    public RecoveryIndexingUpdatesValidator(PrimitiveLongVisitor<RuntimeException> updatedNodeVisitor) {
        this.updatedNodeVisitor = updatedNodeVisitor;
    }

    @Override
    public ValidatedIndexUpdates validate(TransactionRepresentation transaction) throws IOException {
        this.extractor.clear();
        transaction.accept(this.extractor);
        return this.extractor.containsAnyNodeOrPropertyUpdate() ? this : ValidatedIndexUpdates.NONE;
    }

    @Override
    public void flush() {
        this.extractor.visitUpdatedNodeIds(this.updatedNodeVisitor);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasChanges() {
        return this.extractor.containsAnyNodeOrPropertyUpdate();
    }
}

