/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.ObjectUtil;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.cursor.LabelItem;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.ProcedureConstraintViolation;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyConstraintViolationKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class ConstraintEnforcingEntityOperations
implements EntityOperations,
SchemaWriteOperations {
    private static final Predicate<NodePropertyConstraint> UNIQUENESS_CONSTRAINT = Predicates.instanceOf(UniquenessConstraint.class);
    private final EntityWriteOperations entityWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final SchemaWriteOperations schemaWriteOperations;
    private final SchemaReadOperations schemaReadOperations;
    private final ConstraintSemantics constraintSemantics;

    public ConstraintEnforcingEntityOperations(ConstraintSemantics constraintSemantics, EntityWriteOperations entityWriteOperations, EntityReadOperations entityReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaReadOperations schemaReadOperations) {
        this.constraintSemantics = constraintSemantics;
        this.entityWriteOperations = entityWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.schemaWriteOperations = schemaWriteOperations;
        this.schemaReadOperations = schemaReadOperations;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws ConstraintValidationKernelException, EntityNotFoundException {
        Iterator<NodePropertyConstraint> allConstraints = this.schemaReadOperations.constraintsGetForLabel(state, labelId);
        Iterator<NodePropertyConstraint> constraints = this.uniquePropertyConstraints(allConstraints);
        while (constraints.hasNext()) {
            PropertyConstraint constraint = constraints.next();
            int propertyKeyId = constraint.propertyKey();
            Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);
            Throwable throwable = null;
            try {
                NodeItem node = (NodeItem)cursor.get();
                Object propertyValue = node.getProperty(propertyKeyId);
                if (propertyValue == null) continue;
                this.validateNoExistingNodeWithLabelAndProperty(state, labelId, propertyKeyId, propertyValue, node.id());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor == null) continue;
                if (throwable != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cursor.close();
            }
        }
        return this.entityWriteOperations.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws ConstraintValidationKernelException, EntityNotFoundException {
        try (Cursor<NodeItem> cursor = this.nodeCursorById(state, nodeId);){
            NodeItem node = (NodeItem)cursor.get();
            try (Cursor<LabelItem> labels = node.labels();){
                while (labels.next()) {
                    int propertyKeyId;
                    int labelId = ((LabelItem)labels.get()).getAsInt();
                    Iterator<NodePropertyConstraint> constraintIterator = this.uniquePropertyConstraints(this.schemaReadOperations.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId = property.propertyKeyId()));
                    if (!constraintIterator.hasNext()) continue;
                    this.validateNoExistingNodeWithLabelAndProperty(state, labelId, property.propertyKeyId(), property.value(), node.id());
                }
            }
        }
        return this.entityWriteOperations.nodeSetProperty(state, nodeId, property);
    }

    private void validateNoExistingNodeWithLabelAndProperty(KernelStatement state, int labelId, int propertyKeyId, Object value, long modifiedNode) throws ConstraintValidationKernelException {
        try {
            IndexDescriptor indexDescriptor = new IndexDescriptor(labelId, propertyKeyId);
            this.assertIndexOnline(state, indexDescriptor);
            state.locks().acquireExclusive(ResourceTypes.INDEX_ENTRY, ResourceTypes.indexEntryResourceId(labelId, propertyKeyId, ObjectUtil.toString(value)));
            long existing = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, indexDescriptor, value);
            if (existing != -1L && existing != modifiedNode) {
                throw new UniquePropertyConstraintViolationKernelException(labelId, propertyKeyId, value, existing);
            }
        }
        catch (IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintKernelException(e);
        }
    }

    private void assertIndexOnline(KernelStatement state, IndexDescriptor indexDescriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.schemaReadOperations.indexGetState(state, indexDescriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.schemaReadOperations.indexGetFailure(state, indexDescriptor));
    }

    private Iterator<NodePropertyConstraint> uniquePropertyConstraints(Iterator<NodePropertyConstraint> constraints) {
        return new FilteringIterator<NodePropertyConstraint>(constraints, UNIQUENESS_CONSTRAINT);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException {
        this.entityWriteOperations.nodeDelete(state, nodeId);
    }

    @Override
    public long relationshipCreate(KernelStatement statement, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipCreate(statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        this.entityWriteOperations.relationshipDelete(state, relationshipId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        return this.entityWriteOperations.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        return this.entityWriteOperations.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.entityReadOperations.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexSeek(state, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByNumber(KernelStatement statement, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexRangeSeekByNumber(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(KernelStatement statement, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexRangeSeekByString(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(KernelStatement state, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexRangeSeekByPrefix(state, index, prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(KernelStatement state, IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexScan(state, index);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(state, index);
        int labelId = index.getLabelId();
        int propertyKeyId = index.getPropertyKeyId();
        String stringVal = "";
        if (null != value) {
            DefinedProperty property = Property.property(propertyKeyId, value);
            stringVal = property.valueAsString();
        }
        Locks.Client locks = state.locks();
        long indexEntryId = ResourceTypes.indexEntryResourceId(labelId, propertyKeyId, stringVal);
        locks.acquireShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
        long nodeId = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, value);
        if (-1L == nodeId) {
            locks.releaseShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
            locks.acquireExclusive(ResourceTypes.INDEX_ENTRY, indexEntryId);
            nodeId = this.entityReadOperations.nodeGetFromUniqueIndexSeek(state, index, value);
            if (-1L != nodeId) {
                locks.acquireShared(ResourceTypes.INDEX_ENTRY, indexEntryId);
                locks.releaseExclusive(ResourceTypes.INDEX_ENTRY, indexEntryId);
            }
        }
        return nodeId;
    }

    @Override
    public boolean graphHasProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphHasProperty(state, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphGetProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys(KernelStatement state) {
        return this.entityReadOperations.graphGetPropertyKeys(state);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteOperations.nodeCreate(statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll(KernelStatement state) {
        return this.entityReadOperations.nodesGetAll(state);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll(KernelStatement state) {
        return this.entityReadOperations.relationshipsGetAll(state);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement statement, long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.entityReadOperations.relationshipVisit(statement, relId, visitor);
    }

    @Override
    public Cursor<NodeItem> nodeCursorById(KernelStatement statement, long nodeId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeCursorById(statement, nodeId);
    }

    @Override
    public Cursor<NodeItem> nodeCursor(KernelStatement statement, long nodeId) {
        return this.entityReadOperations.nodeCursor(statement, nodeId);
    }

    @Override
    public Cursor<NodeItem> nodeCursor(TxStateHolder txStateHolder, StoreStatement statement, long nodeId) {
        return this.entityReadOperations.nodeCursor(txStateHolder, statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorById(KernelStatement statement, long relId) throws EntityNotFoundException {
        return this.entityReadOperations.relationshipCursorById(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursor(KernelStatement statement, long relId) {
        return this.entityReadOperations.relationshipCursor(statement, relId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursor(TxStateHolder txStateHolder, StoreStatement statement, long relId) {
        return this.entityReadOperations.relationshipCursor(txStateHolder, statement, relId);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetAll(KernelStatement statement) {
        return this.entityReadOperations.nodeCursorGetAll(statement);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll(KernelStatement statement) {
        return this.entityReadOperations.relationshipCursorGetAll(statement);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetForLabel(KernelStatement statement, int labelId) {
        return this.entityReadOperations.nodeCursorGetForLabel(statement, labelId);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeek(KernelStatement statement, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodeCursorGetFromIndexSeek(statement, index, value);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexScan(KernelStatement statement, IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodeCursorGetFromIndexScan(statement, index);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeekByPrefix(KernelStatement statement, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodeCursorGetFromIndexSeekByPrefix(statement, index, prefix);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByNumber(KernelStatement statement, IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodeCursorGetFromIndexRangeSeekByNumber(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByString(KernelStatement statement, IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodeCursorGetFromIndexRangeSeekByString(statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByPrefix(KernelStatement statement, IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodeCursorGetFromIndexRangeSeekByPrefix(statement, index, prefix);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromUniqueIndexSeek(KernelStatement statement, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        return this.entityReadOperations.nodeCursorGetFromUniqueIndexSeek(statement, index, value);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKeyId) throws AlreadyIndexedException, AlreadyConstrainedException {
        return this.schemaWriteOperations.indexCreate(state, labelId, propertyKeyId);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteOperations.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.schemaWriteOperations.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException {
        return this.schemaWriteOperations.uniquePropertyConstraintCreate(state, labelId, propertyKeyId);
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws AlreadyConstrainedException, CreateConstraintFailureException {
        try (Cursor<NodeItem> cursor = this.nodeCursorGetForLabel(state, labelId);){
            this.constraintSemantics.validateNodePropertyExistenceConstraint(cursor, labelId, propertyKeyId);
        }
        return this.schemaWriteOperations.nodePropertyExistenceConstraintCreate(state, labelId, propertyKeyId);
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(KernelStatement state, int relTypeId, int propertyKeyId) throws AlreadyConstrainedException, CreateConstraintFailureException {
        try (Cursor<RelationshipItem> cursor = this.relationshipCursorGetAll(state);){
            this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(cursor, relTypeId, propertyKeyId);
        }
        return this.schemaWriteOperations.relationshipPropertyExistenceConstraintCreate(state, relTypeId, propertyKeyId);
    }

    @Override
    public void constraintDrop(KernelStatement state, NodePropertyConstraint constraint) throws DropConstraintFailureException {
        this.schemaWriteOperations.constraintDrop(state, constraint);
    }

    @Override
    public void constraintDrop(KernelStatement state, RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        this.schemaWriteOperations.constraintDrop(state, constraint);
    }

    @Override
    public void procedureCreate(KernelStatement state, ProcedureSignature signature, String language, String code) throws ProcedureException, ProcedureConstraintViolation {
        this.schemaWriteOperations.procedureCreate(state, signature, language, code);
    }

    @Override
    public void procedureDrop(KernelStatement statement, ProcedureSignature.ProcedureName name) throws ProcedureConstraintViolation, ProcedureException {
        this.schemaWriteOperations.procedureDrop(statement, name);
    }
}

