/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;

public class SystemPropertiesConfiguration {
    private final Iterable<Class<?>> settingsClasses;

    public SystemPropertiesConfiguration(Class<?> ... settingsClasses) {
        this(Arrays.asList(settingsClasses));
    }

    public SystemPropertiesConfiguration(Iterable<Class<?>> settingsClasses) {
        this.settingsClasses = settingsClasses;
    }

    public Map<String, String> apply(Map<String, String> config) {
        HashMap<String, String> systemProperties = new HashMap<String, String>(config);
        for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
            systemProperties.put(prop.getKey().toString(), prop.getValue().toString());
        }
        HashMap<String, String> result = new HashMap<String, String>(config);
        Function<String, String> systemPropertiesFunction = Functions.map(systemProperties);
        for (Map.Entry<Object, Object> prop : System.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            for (Class<?> settingsClass : this.settingsClasses) {
                for (Field field : settingsClass.getFields()) {
                    try {
                        Setting setting = (Setting)field.get(null);
                        if (!setting.name().equals(key)) continue;
                        setting.apply(systemPropertiesFunction);
                        result.put(key, (String)prop.getValue());
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }
}

