/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.DegreeItem;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Adapter {
    private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
    private final CountsRecordState counts;
    private final StoreReadLayer storeLayer;
    private final EntityReadOperations operations;
    private final TxStateHolder txStateHolder;

    public TransactionCountingStateVisitor(TxStateVisitor next, StoreReadLayer storeLayer, EntityReadOperations operations, TxStateHolder txStateHolder, CountsRecordState counts) {
        super(next);
        this.storeLayer = storeLayer;
        this.operations = operations;
        this.txStateHolder = txStateHolder;
        this.counts = counts;
    }

    @Override
    public void visitCreatedNode(long id) {
        this.counts.incrementNodeCount(-1, 1L);
        super.visitCreatedNode(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        block39: {
            try (StoreStatement statement = this.storeLayer.acquireStatement();){
                this.counts.incrementNodeCount(-1, -1L);
                try (Cursor<NodeItem> node = statement.acquireSingleNodeCursor(id);){
                    int[] removed;
                    PrimitiveIntIterator labels;
                    if (!node.next() || !(labels = ((NodeItem)node.get()).getLabels()).hasNext()) break block39;
                    for (int label : removed = PrimitiveIntCollections.asArray((PrimitiveIntIterator)labels)) {
                        this.counts.incrementNodeCount(label, -1L);
                    }
                    try (Cursor<DegreeItem> degrees = ((NodeItem)node.get()).degrees();){
                        while (degrees.next()) {
                            DegreeItem degree = (DegreeItem)degrees.get();
                            for (int label : removed) {
                                this.updateRelationshipsCountsFromDegrees(degree.type(), label, -degree.outgoing(), -degree.incoming());
                            }
                        }
                    }
                }
            }
        }
        super.visitDeletedNode(id);
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
        try {
            this.updateRelationshipCount(startNode, type, endNode, 1);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Nodes with added relationships should exist.", e);
        }
        super.visitCreatedRelationship(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        try {
            this.storeLayer.relationshipVisit(id, this.edge);
            this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", e);
        }
        super.visitDeletedRelationship(id);
    }

    @Override
    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
        block41: {
            try (StoreStatement statement = this.storeLayer.acquireStatement();){
                if (added.isEmpty() && removed.isEmpty()) break block41;
                for (Integer label : added) {
                    this.counts.incrementNodeCount(label, 1L);
                }
                for (Integer label : removed) {
                    this.counts.incrementNodeCount(label, -1L);
                }
                try (Cursor<NodeItem> node = statement.acquireSingleNodeCursor(id);){
                    if (!node.next()) break block41;
                    try (Cursor<DegreeItem> degrees = ((NodeItem)node.get()).degrees();){
                        while (degrees.next()) {
                            DegreeItem degree = (DegreeItem)degrees.get();
                            for (Integer label : added) {
                                this.updateRelationshipsCountsFromDegrees(degree.type(), label, degree.outgoing(), degree.incoming());
                            }
                            for (Integer label : removed) {
                                this.updateRelationshipsCountsFromDegrees(degree.type(), label, -degree.outgoing(), -degree.incoming());
                            }
                        }
                    }
                }
            }
        }
        super.visitNodeLabelChanges(id, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(int type, int label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, type, label, incoming);
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) throws EntityNotFoundException {
        this.updateRelationshipsCountsFromDegrees(type, -1, delta, 0L);
        PrimitiveIntIterator startLabels = this.labelsOf(startNode);
        while (startLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, startLabels.next(), delta, 0L);
        }
        PrimitiveIntIterator endLabels = this.labelsOf(endNode);
        while (endLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, endLabels.next(), 0L, delta);
        }
    }

    /*
     * Exception decompiling
     */
    private PrimitiveIntIterator labelsOf(long nodeId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

