/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.helpers.Function;

public final class UTF8 {
    public static final Function<String, byte[]> encode = new Function<String, byte[]>(){

        public byte[] apply(String s) {
            return UTF8.encode(s);
        }
    };
    public static final Function<byte[], String> decode = new Function<byte[], String>(){

        public String apply(byte[] bytes) {
            return UTF8.decode(bytes);
        }
    };

    public static byte[] encode(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static String getDecodedStringFrom(ByteBuffer source) {
        int count = source.getInt();
        byte[] data = new byte[count];
        source.get(data);
        return UTF8.decode(data);
    }

    public static void putEncodedStringInto(String text, ByteBuffer target) {
        byte[] data = UTF8.encode(text);
        target.putInt(data.length);
        target.put(data);
    }

    public static int computeRequiredByteBufferSize(String text) {
        return UTF8.encode(text).length + 4;
    }

    private UTF8() {
    }
}

