/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

public class Stats {
    private final String name;
    protected int count;
    protected long total;
    protected long high;
    protected long low;

    public Stats(String name) {
        this.name = name;
    }

    public int add(long value) {
        this.total += value;
        if (value < this.low) {
            this.low = value;
        }
        if (value > this.high) {
            this.high = value;
        }
        return ++this.count;
    }

    public long high() {
        return this.high;
    }

    public long low() {
        return this.low;
    }

    public long average() {
        return this.total / (long)this.count;
    }

    public double preciseAverage() {
        return (double)this.total / (double)this.count;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Stats(" + this.name + ", " + this.count + "):");
        builder.append("\n  total: " + this.total);
        builder.append("\n  avg:   " + this.average());
        builder.append("\n  high:  " + this.high);
        builder.append("\n  low:   " + this.low);
        return builder.toString();
    }
}

