/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import org.neo4j.function.Supplier;

public interface DependencyResolver {
    public <T> T resolveDependency(Class<T> var1) throws IllegalArgumentException;

    public <T> T resolveDependency(Class<T> var1, SelectionStrategy var2) throws IllegalArgumentException;

    public <T> Supplier<T> provideDependency(Class<T> var1, SelectionStrategy var2);

    public <T> Supplier<T> provideDependency(Class<T> var1);

    public static abstract class Adapter
    implements DependencyResolver {
        private static final SelectionStrategy FIRST = new SelectionStrategy(){

            @Override
            public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
                Iterator<T> iterator = candidates.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                return iterator.next();
            }
        };

        @Override
        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            return this.resolveDependency(type, FIRST);
        }

        @Override
        public <T> Supplier<T> provideDependency(final Class<T> type, final SelectionStrategy selector) {
            return new Supplier<T>(){

                public T get() {
                    return this.resolveDependency(type, selector);
                }
            };
        }

        @Override
        public <T> Supplier<T> provideDependency(final Class<T> type) {
            return new Supplier<T>(){

                public T get() {
                    return this.resolveDependency(type);
                }
            };
        }
    }

    public static interface SelectionStrategy {
        public <T> T select(Class<T> var1, Iterable<T> var2) throws IllegalArgumentException;
    }
}

