/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.CompleteTransaction;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.lock.LockService;
import org.neo4j.lock.ReentrantLockService;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.Preconditions;

final class ParallelRecoveryVisitor
implements RecoveryApplier {
    private final AtomicLong prevLockedTxId = new AtomicLong(-1L);
    private final StorageEngine storageEngine;
    private final LockService lockService = new ReentrantLockService();
    private final TransactionApplicationMode mode;
    private final CursorContextFactory contextFactory;
    private final String tracerTag;
    private final ExecutorService appliers;
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final int stride;
    private final Semaphore coordination;

    ParallelRecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag) {
        this(storageEngine, mode, contextFactory, tracerTag, Integer.max(1, Math.min(Runtime.getRuntime().availableProcessors() - 1, 16)));
    }

    ParallelRecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag, int numAppliers) {
        this.storageEngine = storageEngine;
        this.mode = mode;
        this.contextFactory = contextFactory;
        this.tracerTag = tracerTag;
        this.appliers = new ThreadPoolExecutor(numAppliers, numAppliers, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(numAppliers), new ThreadPoolExecutor.CallerRunsPolicy());
        this.stride = mode.isReverseStep() ? -1 : 1;
        this.coordination = new Semaphore(numAppliers);
    }

    public boolean visit(CommittedCommandBatchRepresentation commandBatch) throws Exception {
        this.checkFailure();
        this.prevLockedTxId.compareAndSet(-1L, commandBatch.txId() - (long)this.stride);
        this.appliers.submit(this.coordinate(() -> {
            long txId = commandBatch.txId();
            while (this.prevLockedTxId.get() != txId - (long)this.stride) {
                for (int i = 0; i < 100000 && this.prevLockedTxId.get() != txId - (long)this.stride; ++i) {
                    Thread.onSpinWait();
                }
                this.checkFailure();
            }
            try (LockService.Client locks = this.lockService.newClient();){
                this.storageEngine.lockRecoveryCommands(commandBatch.commandBatch(), locks, this.mode);
                boolean myTurn = this.prevLockedTxId.compareAndSet(txId - (long)this.stride, txId);
                Preconditions.checkState((boolean)myTurn, (String)"Something wrong with the algorithm, I thought it was my turn, but apparently it wasn't %d", (Object[])new Object[]{txId});
                this.apply(commandBatch);
            }
            catch (Throwable e) {
                this.failure.compareAndSet(null, e);
            }
            return null;
        }));
        return false;
    }

    private Callable<Void> coordinate(Callable<Void> task) throws InterruptedException {
        this.coordination.acquire();
        return () -> {
            try {
                Void void_ = (Void)task.call();
                return void_;
            }
            finally {
                this.coordination.release();
            }
        };
    }

    private void checkFailure() throws Exception {
        Throwable failure = this.failure.get();
        if (failure != null) {
            Exceptions.throwIfUnchecked((Throwable)failure);
            throw new Exception("One or more recovering transactions failed to apply", failure);
        }
    }

    private void apply(CommittedCommandBatchRepresentation transaction) throws Exception {
        try (CursorContext cursorContext = this.contextFactory.create(this.tracerTag);
             StoreCursors storeCursors = this.storageEngine.createStorageCursors(cursorContext);){
            CompleteTransaction tx = new CompleteTransaction(transaction, cursorContext, storeCursors);
            this.storageEngine.apply((StorageEngineTransaction)tx, this.mode);
        }
    }

    @Override
    public void close() throws Exception {
        this.appliers.shutdown();
        try {
            if (!this.appliers.awaitTermination(1L, TimeUnit.HOURS)) {
                throw new IllegalStateException("Recovery couldn't gracefully await remaining appliers");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.checkFailure();
    }
}

