/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.recovery.ParallelRecoveryVisitor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.kernel.recovery.RecoveryVisitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DefaultRecoveryService
implements RecoveryService {
    private final RecoveryStartInformationProvider recoveryStartInformationProvider;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final LogVersionRepository logVersionRepository;
    private final LogFiles logFiles;
    private final KernelVersionProvider versionProvider;
    private final LogFormatVersionProvider logFormatVersionProvider;
    private final InternalLog log;
    private final boolean doParallelRecovery;
    private final CursorContextFactory contextFactory;
    private final Recovery.StoreFileChecker storeFileChecker;

    DefaultRecoveryService(StorageEngine storageEngine, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, LogVersionRepository logVersionRepository, LogFiles logFiles, KernelVersionProvider versionProvider, LogFormatVersionProvider logFormatVersionProvider, RecoveryStartInformationProvider.Monitor monitor, InternalLog log, boolean doParallelRecovery, CursorContextFactory contextFactory, Recovery.StoreFileChecker storeFileChecker) {
        this.storageEngine = storageEngine;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.logVersionRepository = logVersionRepository;
        this.logFiles = logFiles;
        this.versionProvider = versionProvider;
        this.logFormatVersionProvider = logFormatVersionProvider;
        this.log = log;
        this.doParallelRecovery = doParallelRecovery;
        this.contextFactory = contextFactory;
        this.storeFileChecker = storeFileChecker;
        this.recoveryStartInformationProvider = new RecoveryStartInformationProvider(logFiles, monitor);
    }

    @Override
    public RecoveryStartInformation getRecoveryStartInformation() {
        return this.recoveryStartInformationProvider.get();
    }

    @Override
    public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag) {
        if (this.doParallelRecovery) {
            return new ParallelRecoveryVisitor(this.storageEngine, mode, contextFactory, tracerTag);
        }
        return new RecoveryVisitor(this.storageEngine, mode, contextFactory, tracerTag);
    }

    @Override
    public void checkMissingStoreFiles() {
        Recovery.checkIfUnrecoverable(this.storeFileChecker.check(false));
    }

    @Override
    public CommandBatchCursor getCommandBatches(long appendIndex) throws IOException {
        return this.logicalTransactionStore.getCommandBatches(appendIndex);
    }

    @Override
    public CommandBatchCursor getCommandBatches(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getCommandBatches(position);
    }

    @Override
    public CommandBatchCursor getCommandBatchesInReverseOrder(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getCommandBatchesInReverseOrder(position);
    }

    @Override
    public void missingLogs() {
        ClosedTransactionMetadata lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
        TransactionId lastClosedTransactionId = lastClosedTransaction.transactionId();
        long logVersion = lastClosedTransaction.logPosition().getLogVersion();
        long startOffset = this.logFormatVersionProvider.getCurrentLogFormat().getDefaultDataStartByteOffset();
        this.log.warn("Recovery detected that transaction logs were missing. Resetting offset of last closed transaction to point to the head of %d transaction log file.", new Object[]{logVersion});
        this.transactionIdStore.resetLastClosedTransaction(lastClosedTransactionId.id(), lastClosedTransaction.transactionId().appendIndex(), this.versionProvider.kernelVersion(), logVersion, startOffset, lastClosedTransactionId.checksum(), lastClosedTransactionId.commitTimestamp(), lastClosedTransactionId.consensusIndex());
        this.logVersionRepository.setCurrentLogVersion(logVersion);
        this.logVersionRepository.setCheckpointLogVersion(Math.max(0L, this.logFiles.getCheckpointFile().getLogRangeInfo().highestVersion()));
        this.tryRemoveLegacyCheckpointFiles();
    }

    @Override
    public void transactionsRecovered(CommittedCommandBatchRepresentation.BatchInformation highestTransactionRecoveredBatch, AppendIndexProvider recoverAppendIndexProvider, LogPosition lastRecoveredTransactionPosition, LogPosition positionAfterLastRecoveredTransaction, LogPosition checkpointPosition) {
        if (highestTransactionRecoveredBatch != null) {
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(highestTransactionRecoveredBatch.txId(), highestTransactionRecoveredBatch.appendIndex(), highestTransactionRecoveredBatch.kernelVersion(), highestTransactionRecoveredBatch.checksum(), highestTransactionRecoveredBatch.timeWritten(), highestTransactionRecoveredBatch.consensusIndex(), lastRecoveredTransactionPosition.getByteOffset(), lastRecoveredTransactionPosition.getLogVersion(), recoverAppendIndexProvider.getLastAppendIndex());
            long lastRecoveredTxId = highestTransactionRecoveredBatch.txId();
            this.contextFactory.init(() -> new TransactionIdSnapshot(lastRecoveredTxId), () -> lastRecoveredTxId);
        } else {
            ClosedTransactionMetadata lastClosedTransaction = this.transactionIdStore.getLastClosedTransaction();
            this.log.warn("Recovery detected that transaction logs tail can't be trusted. Resetting offset of last closed transaction to point to the last recoverable log position: " + String.valueOf(positionAfterLastRecoveredTransaction));
            this.transactionIdStore.resetLastClosedTransaction(lastClosedTransaction.transactionId().id(), lastClosedTransaction.transactionId().appendIndex(), this.versionProvider.kernelVersion(), positionAfterLastRecoveredTransaction.getLogVersion(), positionAfterLastRecoveredTransaction.getByteOffset(), -559063315, 0L, -1L);
        }
        this.logVersionRepository.setCurrentLogVersion(positionAfterLastRecoveredTransaction.getLogVersion());
        this.logVersionRepository.setCheckpointLogVersion(checkpointPosition == LogPosition.UNSPECIFIED ? 0L : checkpointPosition.getLogVersion());
    }

    private void tryRemoveLegacyCheckpointFiles() {
        try {
            Path[] detachedCheckpointFiles;
            CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
            for (Path obsoleteCheckpointFile : detachedCheckpointFiles = checkpointFile.getMatchedFiles()) {
                FileUtils.deleteFile((Path)obsoleteCheckpointFile);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to delete legacy checkpoint files.", (Throwable)e);
        }
    }
}

