/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.io.IOException;
import java.time.Clock;
import java.util.function.LongSupplier;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.RotatableFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.monitoring.Panic;

public class FileLogRotation
implements LogRotation {
    private final Clock clock;
    private final LogRotationMonitor monitor;
    private final LogRotationMonitor.LogType type;
    private final Panic databasePanic;
    private final RotatableFile rotatableFile;
    private long lastRotationCompleted;
    private final LongSupplier lastAppendIndexSupplier;
    private final LongSupplier currentFileVersionSupplier;
    private final KernelVersionProvider kernelVersionProvider;

    public static LogRotation checkpointLogRotation(CheckpointLogFile checkpointLogFile, LogFile logFile, Clock clock, Panic databasePanic, LogRotationMonitor monitor, KernelVersionProvider kernelVersionProvider) {
        return new FileLogRotation(checkpointLogFile, LogRotationMonitor.LogType.CHECKPOINT, clock, databasePanic, monitor, logFile::getLastEntryAppendIndexInLogFiles, checkpointLogFile::getCurrentLogVersion, kernelVersionProvider);
    }

    public static LogRotation transactionLogRotation(LogFile logFile, Clock clock, Panic databasePanic, LogRotationMonitor monitor, KernelVersionProvider kernelVersionProvider) {
        return new FileLogRotation(logFile, LogRotationMonitor.LogType.TRANSACTIONS, clock, databasePanic, monitor, logFile::getLastEntryAppendIndexInLogFiles, logFile::getCurrentLogVersion, kernelVersionProvider);
    }

    private FileLogRotation(RotatableFile rotatableFile, LogRotationMonitor.LogType type, Clock clock, Panic databasePanic, LogRotationMonitor monitor, LongSupplier lastAppendIndexSupplier, LongSupplier currentFileVersionSupplier, KernelVersionProvider kernelVersionProvider) {
        this.clock = clock;
        this.monitor = monitor;
        this.type = type;
        this.databasePanic = databasePanic;
        this.rotatableFile = rotatableFile;
        this.lastAppendIndexSupplier = lastAppendIndexSupplier;
        this.currentFileVersionSupplier = currentFileVersionSupplier;
        this.kernelVersionProvider = kernelVersionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rotateLogIfNeeded(LogRotateEvents logRotateEvents) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            RotatableFile rotatableFile = this.rotatableFile;
            synchronized (rotatableFile) {
                return this.locklessRotateLogIfNeeded(logRotateEvents);
            }
        }
        return false;
    }

    public boolean locklessBatchedRotateLogIfNeeded(LogRotateEvents logRotateEvents, long lastAppendIndex, KernelVersion kernelVersion, int checksum, LogFormat logFormat) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            TransactionLogFile logFile = (TransactionLogFile)this.rotatableFile;
            long version = logFile.getLogRangeInfo().highestVersion();
            this.doRotate(logRotateEvents, lastAppendIndex, () -> version, () -> logFile.rotate(kernelVersion, lastAppendIndex, checksum, logFormat));
            return true;
        }
        return false;
    }

    public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            this.doRotate(logRotateEvents, this.lastAppendIndexSupplier.getAsLong(), this.currentFileVersionSupplier, this.rotatableFile::rotate);
            return true;
        }
        return false;
    }

    public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, boolean force) throws IOException {
        if (force || this.rotatableFile.rotationNeeded()) {
            this.doRotate(logRotateEvents, this.lastAppendIndexSupplier.getAsLong(), this.currentFileVersionSupplier, () -> this.rotatableFile.rotate(kernelVersion));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateLogFile(LogRotateEvents logRotateEvents) throws IOException {
        RotatableFile rotatableFile = this.rotatableFile;
        synchronized (rotatableFile) {
            this.doRotate(logRotateEvents, this.lastAppendIndexSupplier.getAsLong(), this.currentFileVersionSupplier, this.rotatableFile::rotate);
        }
    }

    public void locklessRotateLogFile(LogRotateEvents logRotateEvents, long lastAppendIndex, int previousChecksum, long lastTerm) throws IOException {
        this.doRotate(logRotateEvents, lastAppendIndex, this.currentFileVersionSupplier, () -> this.rotatableFile.rotate(this.kernelVersionProvider.kernelVersion(), lastAppendIndex, previousChecksum));
    }

    public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum) throws IOException {
        this.doRotate(logRotateEvents, lastAppendIndex, this.currentFileVersionSupplier, () -> this.rotatableFile.rotate(kernelVersion, lastAppendIndex, previousChecksum));
    }

    public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum, LogFormat logFormat) throws IOException {
        this.doRotate(logRotateEvents, lastAppendIndex, this.currentFileVersionSupplier, () -> this.rotatableFile.rotate(kernelVersion, lastAppendIndex, previousChecksum, logFormat));
    }

    public long rotationSize() {
        return this.rotatableFile.rotationSize();
    }

    private void doRotate(LogRotateEvents logRotateEvents, long appendIndex, LongSupplier currentFileVersionSupplier, FileRotator fileRotator) throws IOException {
        try (LogRotateEvent rotateEvent = logRotateEvents.beginLogRotate();){
            long currentVersion = currentFileVersionSupplier.getAsLong();
            this.databasePanic.assertNoPanic(IOException.class);
            long startTimeMillis = this.clock.millis();
            this.monitor.startRotation(this.type, currentVersion);
            RotatableFile.RotationInfo logFileInfo = fileRotator.rotate();
            long millisSinceLastRotation = this.lastRotationCompleted == 0L ? 0L : startTimeMillis - this.lastRotationCompleted;
            this.lastRotationCompleted = this.clock.millis();
            long rotationElapsedTime = this.lastRotationCompleted - startTimeMillis;
            rotateEvent.rotationCompleted(rotationElapsedTime);
            this.monitor.finishLogRotation(logFileInfo.file(), this.type, currentVersion, logFileInfo.logHeader(), appendIndex, rotationElapsedTime, millisSinceLastRotation);
        }
    }

    @FunctionalInterface
    private static interface FileRotator {
        public RotatableFile.RotationInfo rotate() throws IOException;
    }
}

