/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogIndexEncoding;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogRangeInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailAppendIndexProvider;
import org.neo4j.kernel.recovery.LogTailScannerMonitor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedLogTailScanner {
    static final long NO_TRANSACTION_ID = -1L;
    public static final byte NO_ENTRY = 0;
    private static final String TRANSACTION_LOG_NAME = "Transaction";
    private static final String CHECKPOINT_LOG_NAME = "Checkpoint";
    private final LogFiles logFiles;
    private final CommandReaderFactory commandReaderFactory;
    private final LogTailScannerMonitor monitor;
    private final MemoryTracker memoryTracker;
    private final CheckpointFile checkpointFile;
    private final boolean failOnCorruptedLogFiles;
    private final FileSystemAbstraction fileSystem;
    private final KernelVersionProvider fallbackKernelVersionProvider;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final LogFormatVersionProvider fallbackLogFormatVersionProvider;
    private LogTailMetadata logTail;

    public DetachedLogTailScanner(LogFiles logFiles, TransactionLogFilesContext context, CheckpointFile checkpointFile, LogTailScannerMonitor monitor, LogTailMetadata externalLogTail) {
        this.logFiles = logFiles;
        this.commandReaderFactory = context.getCommandReaderFactory();
        this.memoryTracker = context.getMemoryTracker();
        this.checkpointFile = checkpointFile;
        this.fileSystem = context.getFileSystem();
        this.failOnCorruptedLogFiles = context.isFailOnCorruptedLogFiles();
        this.fallbackKernelVersionProvider = context.getEmptyLogsKernelVersionProvider();
        this.fallbackLogFormatVersionProvider = context.getEmptyLogsLogFormatVersionProvider();
        this.logTail = externalLogTail;
        this.monitor = monitor;
        this.binarySupportedKernelVersions = context.getBinarySupportedKernelVersions();
    }

    public LogTailInformation findLogTail() {
        LogFile logFile = this.logFiles.getLogFile();
        LogRangeInfo logRangeInfo = logFile.getLogRangeInfo();
        long highestLogVersion = logRangeInfo.highestVersion();
        long lowestLogVersion = logRangeInfo.lowestVersion();
        try {
            Optional<CheckpointInfo> lastAccessibleCheckpoint = this.checkpointFile.findLatestCheckpoint();
            if (lastAccessibleCheckpoint.isEmpty()) {
                return this.noCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion);
            }
            CheckpointInfo checkpoint = lastAccessibleCheckpoint.get();
            this.verifyCheckpointPosition(checkpoint.channelPositionAfterCheckpoint());
            if (this.isValidCheckpoint(logFile, checkpoint)) {
                return this.validCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion, checkpoint);
            }
            if (this.failOnCorruptedLogFiles) {
                String exceptionMessage = String.format("Last available %s checkpoint does not point to a valid location in transaction logs.", checkpoint);
                DetachedLogTailScanner.throwUnableToCleanRecover(new RuntimeException(exceptionMessage));
            }
            List<CheckpointInfo> checkpointInfos = this.checkpointFile.reachableCheckpoints();
            ListIterator<CheckpointInfo> reverseCheckpoints = checkpointInfos.listIterator(checkpointInfos.size() - 1);
            while (reverseCheckpoints.hasPrevious()) {
                CheckpointInfo previousCheckpoint = reverseCheckpoints.previous();
                if (!this.isValidCheckpoint(logFile, previousCheckpoint)) continue;
                return this.validCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion, previousCheckpoint);
            }
            return this.noCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private LogTailInformation validCheckpointLogTail(LogFile logFile, long highestLogVersion, long lowestLogVersion, CheckpointInfo checkpoint) throws IOException {
        LogPosition transactionLogPosition = checkpoint.transactionLogPosition();
        PostCheckpointInfo postCheckPointInfo = this.getPostCheckpointInfo(logFile, checkpoint.kernelVersion(), transactionLogPosition);
        LogFormat logFormatVersion = this.checkpointFile.extractHeader(checkpoint.checkpointEntryPosition().getLogVersion()).getLogFormatVersion();
        return new LogTailInformation(this.loadConsensusIndexIfNeeded(logFile, checkpoint), checkpoint.olderTransactionRecoveryRequired() || postCheckPointInfo.isPresent(), postCheckPointInfo.appendIndex(), lowestLogVersion == -1L, highestLogVersion, postCheckPointInfo.getEntryVersion(), checkpoint.storeId(), this.fallbackKernelVersionProvider, () -> logFormatVersion, new DetachedLogTailAppendIndexProvider(this.commandReaderFactory, this.binarySupportedKernelVersions, this.logFiles.getLogFile(), checkpoint.kernelVersion(), checkpoint.appendIndex(), transactionLogPosition, this.memoryTracker));
    }

    private PostCheckpointInfo getPostCheckpointInfo(LogFile logFile, KernelVersion kernelVersion, LogPosition logPosition) throws IOException {
        return kernelVersion.isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED) ? this.getAppendIndexPostCheckPointInfo(logFile, logPosition) : this.getLegacyPostCheckPointInfo(logFile, logPosition).toPostCheckpointInfo();
    }

    private LogTailInformation noCheckpointLogTail(LogFile logFile, long highestLogVersion, long lowestLogVersion) throws IOException {
        LogHeader logHeader;
        LogPosition logPosition = LogPosition.UNSPECIFIED;
        KernelVersion kernelVersion = KernelVersion.EARLIEST;
        LogFormatVersionProvider logFormat = this.fallbackLogFormatVersionProvider;
        if (logFile.versionExists(lowestLogVersion) && (logHeader = logFile.extractHeader(lowestLogVersion)) != null) {
            logPosition = logHeader.getStartPosition();
            kernelVersion = logHeader.getLogFormatVersion().getFromKernelVersion();
            logFormat = () -> ((LogHeader)logHeader).getLogFormatVersion();
        }
        PostCheckpointInfo entries = this.getPostCheckpointInfo(logFile, kernelVersion, logPosition);
        LogPosition startPosition = DetachedLogTailScanner.getLogStartPosition(logFile, lowestLogVersion);
        KernelVersion logFileVersion = entries.kernelVersion == 0 ? KernelVersion.EARLIEST : KernelVersion.getForVersion((byte)entries.kernelVersion);
        return new LogTailInformation(entries.isPresent(), entries.appendIndex(), lowestLogVersion == -1L, highestLogVersion, entries.getEntryVersion(), this.fallbackKernelVersionProvider, logFormat, new DetachedLogTailAppendIndexProvider(this.commandReaderFactory, this.binarySupportedKernelVersions, this.logFiles.getLogFile(), logFileVersion, 0L, startPosition, this.memoryTracker));
    }

    private static LogPosition getLogStartPosition(LogFile logFile, long lowestLogVersion) throws IOException {
        if (!logFile.versionExists(lowestLogVersion)) {
            return LogPosition.UNSPECIFIED;
        }
        LogHeader logHeader = logFile.extractHeader(lowestLogVersion);
        return logHeader != null ? logHeader.getStartPosition() : LogPosition.UNSPECIFIED;
    }

    private boolean isValidCheckpoint(LogFile logFile, CheckpointInfo checkpointInfo) throws IOException {
        LogPosition logPosition = checkpointInfo.transactionLogPosition();
        long logVersion = logPosition.getLogVersion();
        if (!logFile.versionExists(logVersion)) {
            return false;
        }
        Path logFileForVersion = logFile.getLogFileForVersion(logVersion);
        if (this.fileSystem.getFileSize(logFileForVersion) < logPosition.getByteOffset()) {
            return false;
        }
        LogHeader logHeader = logFile.extractHeader(logVersion);
        if (logHeader == null) {
            return false;
        }
        StoreId headerStoreId = logHeader.getStoreId();
        return headerStoreId == null || headerStoreId.isSameOrUpgradeSuccessor(checkpointInfo.storeId()) || checkpointInfo.storeId().isSameOrUpgradeSuccessor(headerStoreId);
    }

    private LegacyPostCheckpointInfo getLegacyPostCheckPointInfo(LogFile logFile, LogPosition logPosition) throws IOException {
        boolean corruptedTransactionLogs = false;
        LogEntryStart start = null;
        LogEntryCommit commit = null;
        LogEntryChunkEnd chunkEnd = null;
        LogPosition lookupPosition = null;
        if (logPosition != LogPosition.UNSPECIFIED) {
            long logVersion = logPosition.getLogVersion();
            try {
                while (logFile.versionExists(logVersion)) {
                    LogPosition position;
                    lookupPosition = lookupPosition == null ? logPosition : logFile.extractHeader(logVersion).getStartPosition();
                    VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions, this.memoryTracker);
                    try (ReadableLogChannel reader = logFile.getReader(lookupPosition, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                        while ((start == null || commit == null) && cursor.next()) {
                            LogEntryStart e;
                            LogEntry entry = cursor.get();
                            if (commit == null && entry instanceof LogEntryCommit) {
                                LogEntryCommit e2;
                                commit = e2 = (LogEntryCommit)entry;
                                continue;
                            }
                            if (chunkEnd == null && entry instanceof LogEntryChunkEnd) {
                                LogEntryChunkEnd e3;
                                chunkEnd = e3 = (LogEntryChunkEnd)entry;
                                continue;
                            }
                            if (start != null || !(entry instanceof LogEntryStart)) continue;
                            start = e = (LogEntryStart)entry;
                        }
                        position = reader.getCurrentLogPosition();
                    }
                    if (start != null && (commit != null || chunkEnd != null)) {
                        return new LegacyPostCheckpointInfo(start, commit, chunkEnd);
                    }
                    corruptedTransactionLogs = logEntryReader.hasBrokenLastEntry();
                    if (!corruptedTransactionLogs) {
                        this.verifyReaderPosition(logVersion, position);
                    }
                    ++logVersion;
                }
            }
            catch (Error | ClosedByInterruptException e) {
                throw e;
            }
            catch (Throwable t) {
                this.monitor.corruptedLogFile(logVersion, t);
                if (this.failOnCorruptedLogFiles) {
                    DetachedLogTailScanner.throwUnableToCleanRecover(t);
                }
                corruptedTransactionLogs = true;
            }
        }
        return new LegacyPostCheckpointInfo(start, commit, chunkEnd, corruptedTransactionLogs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PostCheckpointInfo getAppendIndexPostCheckPointInfo(LogFile logFile, LogPosition logPosition) throws IOException {
        boolean corruptedTransactionLogs = false;
        LogPosition lookupPosition = null;
        if (logPosition == LogPosition.UNSPECIFIED) return new PostCheckpointInfo(0L, 0, corruptedTransactionLogs);
        long logVersion = logPosition.getLogVersion();
        try {
            while (logFile.versionExists(logVersion)) {
                lookupPosition = lookupPosition == null ? logPosition : logFile.extractHeader(logVersion).getStartPosition();
                VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions, this.memoryTracker);
                LogHeader logHeader = logFile.extractHeader(logVersion);
                LogVersionBridge readerBridge = logHeader.getLogFormatVersion().usesSegments() ? ReaderLogVersionBridge.forFile(logFile) : LogVersionBridge.NO_MORE_CHANNELS;
                try (ReadableLogChannel reader = logFile.getReader(lookupPosition, readerBridge);
                     LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                    if (cursor.next()) {
                        AbstractVersionAwareLogEntry logEntry;
                        AbstractVersionAwareLogEntry abstractVersionAwareLogEntry = logEntry = (AbstractVersionAwareLogEntry)cursor.get();
                        Objects.requireNonNull(abstractVersionAwareLogEntry);
                        Object object = abstractVersionAwareLogEntry;
                        int n = 0;
                        object = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LogEntryStart.class, LogEntryChunkStart.class, LogEntryRollback.class}, (Object)object, n)) {
                            case 0 -> {
                                LogEntryStart startEntry = (LogEntryStart)object;
                                yield new PostCheckpointInfo(startEntry.getAppendIndex(), startEntry.kernelVersion().version(), false);
                            }
                            case 1 -> {
                                LogEntryChunkStart chunkStart = (LogEntryChunkStart)object;
                                yield new PostCheckpointInfo(chunkStart.getAppendIndex(), chunkStart.kernelVersion().version(), false);
                            }
                            case 2 -> {
                                LogEntryRollback rollback = (LogEntryRollback)object;
                                yield new PostCheckpointInfo(rollback.getAppendIndex(), rollback.kernelVersion().version(), false);
                            }
                            default -> new PostCheckpointInfo(0L, logEntry.kernelVersion().version(), true);
                        };
                        return object;
                    }
                    LogPosition position = reader.getCurrentLogPosition();
                    corruptedTransactionLogs = logEntryReader.hasBrokenLastEntry();
                    if (!corruptedTransactionLogs) {
                        this.verifyReaderPosition(position.getLogVersion(), position);
                    }
                }
                ++logVersion;
            }
            return new PostCheckpointInfo(0L, 0, corruptedTransactionLogs);
        }
        catch (Error | ClosedByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            this.monitor.corruptedLogFile(logVersion, t);
            if (this.failOnCorruptedLogFiles) {
                DetachedLogTailScanner.throwUnableToCleanRecover(t);
            }
            corruptedTransactionLogs = true;
        }
        return new PostCheckpointInfo(0L, 0, corruptedTransactionLogs);
    }

    private CheckpointInfo loadConsensusIndexIfNeeded(LogFile logFile, CheckpointInfo checkpoint) throws IOException {
        if (checkpoint.consensusIndexInCheckpoint()) {
            return checkpoint;
        }
        long requiredTransactionId = checkpoint.transactionId().id();
        long consensusIndex = this.findConsensusIndexForTransactionId(logFile, requiredTransactionId, checkpoint.transactionLogPosition());
        if (consensusIndex == -1L) {
            return checkpoint;
        }
        return new CheckpointInfo(checkpoint.oldestNotVisibleTransactionLogPosition(), checkpoint.transactionLogPosition(), checkpoint.storeId(), checkpoint.checkpointEntryPosition(), checkpoint.channelPositionAfterCheckpoint(), checkpoint.checkpointFilePostReadPosition(), checkpoint.kernelVersion(), checkpoint.kernelVersionByte(), new TransactionId(checkpoint.transactionId().id(), checkpoint.transactionId().appendIndex(), checkpoint.transactionId().kernelVersion(), checkpoint.transactionId().checksum(), checkpoint.transactionId().commitTimestamp(), consensusIndex), checkpoint.appendIndex(), checkpoint.reason());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long findConsensusIndexForTransactionId(LogFile logFile, long requiredTransactionId, LogPosition checkpointTransactionPosition) throws IOException {
        long logVersion = checkpointTransactionPosition.getLogVersion();
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions, this.memoryTracker);
        try {
            while (logFile.versionExists(logVersion)) {
                LogPosition logHeaderStart;
                LogHeader logHeader = logFile.extractHeader(logVersion);
                if (logHeader != null && (logHeaderStart = logHeader.getStartPosition()).isBefore(checkpointTransactionPosition)) {
                    try (ReadableLogChannel reader = logFile.getReader(logHeaderStart, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor((LogEntryReader)logEntryReader, (ReadableLogPositionAwareChannel)reader);){
                        LogEntryStart start = null;
                        while (cursor.next()) {
                            LogEntry entry = cursor.get();
                            if (entry instanceof LogEntryStart) {
                                LogEntryStart e;
                                start = e = (LogEntryStart)entry;
                                continue;
                            }
                            if (!(entry instanceof LogEntryCommit)) continue;
                            LogEntryCommit commit = (LogEntryCommit)entry;
                            if (start != null && commit.getTxId() == requiredTransactionId) {
                                long l = LogIndexEncoding.decodeLogIndex(start.getAdditionalHeader());
                                return l;
                            }
                            start = null;
                        }
                    }
                }
                --logVersion;
            }
            return -1L;
        }
        catch (Error | ClosedByInterruptException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    private void verifyReaderPosition(long version, LogPosition logPosition) throws IOException {
        LogFile logFile = this.logFiles.getLogFile();
        long highestLogVersion = logFile.getLogRangeInfo().highestVersion();
        try (PhysicalLogVersionedStoreChannel channel = logFile.openForVersion(version);){
            this.verifyLogChannel(channel, logPosition, version, highestLogVersion, true, TRANSACTION_LOG_NAME);
        }
    }

    private void verifyCheckpointPosition(LogPosition lastCheckpointPosition) throws IOException {
        long checkpointLogVersion = lastCheckpointPosition.getLogVersion();
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        long highestLogVersion = checkpointFile.getLogRangeInfo().highestVersion();
        try (PhysicalLogVersionedStoreChannel channel = checkpointFile.openForVersion(checkpointLogVersion);){
            channel.position(lastCheckpointPosition.getByteOffset());
            if (this.failOnCorruptedLogFiles) {
                this.verifyLogChannel(channel, lastCheckpointPosition, checkpointLogVersion, highestLogVersion, false, CHECKPOINT_LOG_NAME);
            }
        }
    }

    private void verifyLogChannel(PhysicalLogVersionedStoreChannel channel, LogPosition logPosition, long currentVersion, long highestVersion, boolean checkLastFile, String logName) throws IOException {
        this.verifyLogVersion(currentVersion, logPosition);
        long logFileSize = channel.size();
        long channelLeftovers = Math.subtractExact(logFileSize, logPosition.getByteOffset());
        if (channelLeftovers != 0L) {
            if (checkLastFile) {
                DetachedLogTailScanner.verifyLastFile(highestVersion, currentVersion, logPosition, logFileSize, channelLeftovers, logName);
            }
            this.verifyNoMoreReadableDataAvailable(currentVersion, (LogVersionedStoreChannel)channel, logPosition, channelLeftovers, logName);
        }
    }

    private void verifyLogVersion(long version, LogPosition logPosition) {
        if (logPosition.getLogVersion() != version) {
            throw new IllegalStateException(String.format("Expected to observe log positions only for log file with version %d but encountered version %d while reading %s.", version, logPosition.getLogVersion(), FileUtils.getCanonicalFile((Path)this.logFiles.getLogFile().getLogFileForVersion(version))));
        }
    }

    static void throwUnableToCleanRecover(Throwable t) {
        throw new RuntimeException("Error reading transaction logs, recovery not possible. To force the database to start anyway, you can specify '" + GraphDatabaseInternalSettings.fail_on_corrupted_log_files.name() + "=false'. This will try to recover as much as possible and then truncate the corrupt part of the transaction log. Doing this means your database integrity might be compromised, please consider restoring from a consistent backup instead.", t);
    }

    private static void verifyLastFile(long highestLogVersion, long version, LogPosition logPosition, long logFileSize, long channelLeftovers, String logName) {
        if (version != highestLogVersion) {
            throw new RuntimeException(String.format("%s log files with version %d has %d unreadable bytes. Was able to read upto %d but %d is available.", logName, version, channelLeftovers, logPosition.getByteOffset(), logFileSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNoMoreReadableDataAvailable(long version, LogVersionedStoreChannel channel, LogPosition logPosition, long channelLeftovers, String logName) throws IOException {
        long initialPosition = channel.position();
        try {
            channel.position(logPosition.getByteOffset());
            try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(Numbers.safeCastLongToInt((long)Math.min(ByteUnit.kibiBytes((long)12L), channelLeftovers)), ByteOrder.LITTLE_ENDIAN, this.memoryTracker);){
                ByteBuffer byteBuffer = scopedBuffer.getBuffer();
                channel.readAll(byteBuffer);
                byteBuffer.flip();
                if (ByteBuffers.directBufferContainsNonZeroData((ByteBuffer)byteBuffer)) {
                    throw new RuntimeException(String.format("%s log file with version %d has some data available after last readable log entry. Last readable position %d, read ahead buffer content: %s.", logName, version, logPosition.getByteOffset(), DetachedLogTailScanner.dumpBufferToString(byteBuffer)));
                }
            }
        }
        finally {
            channel.position(initialPosition);
        }
    }

    public LogTailMetadata getTailMetadata() {
        if (this.logTail == null) {
            this.logTail = this.findLogTail();
        }
        return this.logTail;
    }

    private static String dumpBufferToString(ByteBuffer byteBuffer) {
        byte[] data = new byte[byteBuffer.limit()];
        byteBuffer.get(data);
        return Arrays.toString(data);
    }

    private record PostCheckpointInfo(long appendIndex, byte kernelVersion, boolean corruptedLogs) {
        public boolean isPresent() {
            return this.appendIndex >= 1L || this.corruptedLogs;
        }

        public byte getEntryVersion() {
            return this.kernelVersion;
        }
    }

    private static class LegacyPostCheckpointInfo {
        private final LogEntryStart start;
        private final LogEntryCommit commit;
        private final LogEntryChunkEnd chunkEnd;
        private final boolean corruptedLogs;

        LegacyPostCheckpointInfo(LogEntryStart start, LogEntryCommit commit, LogEntryChunkEnd chunkEnd) {
            this(start, commit, chunkEnd, false);
        }

        LegacyPostCheckpointInfo(LogEntryStart start, LogEntryCommit commit, LogEntryChunkEnd chunkEnd, boolean corruptedLogs) {
            this.start = start;
            this.commit = commit;
            this.chunkEnd = chunkEnd;
            this.corruptedLogs = corruptedLogs;
        }

        PostCheckpointInfo toPostCheckpointInfo() {
            return new PostCheckpointInfo(this.getAppendIndex(), this.getEntryVersion(), this.corruptedLogs);
        }

        private long getAppendIndex() {
            if (this.commit != null) {
                return this.commit.getTxId();
            }
            if (this.chunkEnd != null) {
                return this.chunkEnd.getTransactionId();
            }
            if (this.start != null) {
                return this.start.getAppendIndex();
            }
            return -1L;
        }

        private byte getEntryVersion() {
            if (this.start != null) {
                return this.start.kernelVersion().version();
            }
            return 0;
        }
    }
}

