/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collections;
import org.neo4j.common.Subject;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CompleteCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.LogForceEvents;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesSpan;
import org.neo4j.kernel.impl.transaction.log.files.LogRangeInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.Leases;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class TransactionLogInitializer {
    private final FileSystemAbstraction fs;
    private final MetadataProvider metadataProvider;
    private final LogMetadataProvider logMetadataProvider;
    private final StorageEngineFactory storageEngineFactory;

    public static LogFilesInitializer getLogFilesInitializer() {
        return new LogFilesInitializer(){

            public void initializeLogFiles(DatabaseLayout databaseLayout, MetadataProvider metadataProvider, LogMetadataProvider logMetadataProvider, FileSystemAbstraction fileSystem, String checkpointReason, Config config) {
                try {
                    TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, metadataProvider, logMetadataProvider, (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow());
                    initializer.initializeEmptyLogFile(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason, config);
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Failed to initialize transaction log files.", (Throwable)e);
                }
            }

            public void clearHistoryAndInitializeLogFiles(DatabaseLayout databaseLayout, MetadataProvider metadataProvider, LogMetadataProvider logMetadataProvider, FileSystemAbstraction fileSystem, String checkpointReason) {
                try {
                    TransactionLogInitializer initializer = new TransactionLogInitializer(fileSystem, metadataProvider, logMetadataProvider, (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fileSystem, (DatabaseLayout)databaseLayout).orElseThrow());
                    initializer.migrateExistingLogFiles(databaseLayout, databaseLayout.getTransactionLogsDirectory(), checkpointReason, Config.defaults());
                }
                catch (Exception e) {
                    throw new UnderlyingStorageException("Failed to clear history and initialize transaction log files.", (Throwable)e);
                }
            }
        };
    }

    public TransactionLogInitializer(FileSystemAbstraction fs, MetadataProvider metadataProvider, LogMetadataProvider logMetadataProvider, StorageEngineFactory storageEngineFactory) {
        this.fs = fs;
        this.metadataProvider = metadataProvider;
        this.logMetadataProvider = logMetadataProvider;
        this.storageEngineFactory = storageEngineFactory;
    }

    public long initializeEmptyLogFile(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason, Config config) throws IOException {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory, config);){
            LogFiles logFiles = span.getLogFiles();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    public long migrateExistingLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, String checkpointReason, Config config) throws Exception {
        try (LogFilesSpan span = this.buildLogFiles(layout, transactionLogsDirectory, config);){
            LogFiles logFiles = span.getLogFiles();
            LogFile logFile = logFiles.getLogFile();
            LogRangeInfo logRangeInfo = logFile.getLogRangeInfo();
            for (long version = logRangeInfo.lowestVersion(); version <= logRangeInfo.highestVersion(); ++version) {
                this.fs.deleteFile(logFile.getLogFileForVersion(version));
            }
            CheckpointFile checkpointFile = logFiles.getCheckpointFile();
            LogRangeInfo checkpointLogVersionRange = checkpointFile.getLogRangeInfo();
            for (long version = checkpointLogVersionRange.lowestVersion(); version <= checkpointLogVersionRange.highestVersion(); ++version) {
                this.fs.deleteFile(checkpointFile.getLogFileForVersion(version));
            }
            logFile.rotate();
            checkpointFile.rotate();
            long l = this.appendEmptyTransactionAndCheckPoint(logFiles, checkpointReason);
            return l;
        }
    }

    private LogFilesSpan buildLogFiles(DatabaseLayout layout, Path transactionLogsDirectory, Config config) throws IOException {
        LogFilesBuilder builder = LogFilesBuilder.writeableBuilder(layout, this.fs, (KernelVersionProvider)this.logMetadataProvider, (LogFormatVersionProvider)this.logMetadataProvider).withLogVersionRepository((LogVersionRepository)this.logMetadataProvider).withTransactionIdStore((TransactionIdStore)this.logMetadataProvider).withAppendIndexProvider((AppendIndexProvider)this.logMetadataProvider).withStoreId(this.metadataProvider.getStoreId()).withLogsDirectory(transactionLogsDirectory).withStorageEngineFactory(this.storageEngineFactory).withConfig(config).withDatabaseHealth(new DatabaseHealth(HealthEventGenerator.NO_OP, (InternalLog)NullLog.getInstance())).withLogFormatVersionProvider((LogFormatVersionProvider)this.logMetadataProvider).withKernelVersionProvider((KernelVersionProvider)this.logMetadataProvider);
        if (this.logMetadataProvider.kernelVersion() == KernelVersion.GLORIOUS_FUTURE) {
            builder.withConfig(Config.defaults((Setting)GraphDatabaseInternalSettings.latest_kernel_version, (Object)this.logMetadataProvider.kernelVersion().version()));
        }
        LogFiles logFiles = builder.build();
        return new LogFilesSpan(new Lifespan(new Lifecycle[]{logFiles}), logFiles);
    }

    private long appendEmptyTransactionAndCheckPoint(LogFiles logFiles, String reason) throws IOException {
        TransactionId committedTx = this.logMetadataProvider.getLastCommittedTransaction();
        long consensusIndex = -1L;
        long timestamp = committedTx.commitTimestamp();
        long upgradeTransactionId = this.logMetadataProvider.nextCommittingTransactionId();
        long appendIndex = this.logMetadataProvider.nextAppendIndex();
        KernelVersion kernelVersion = this.logMetadataProvider.kernelVersion();
        LogFile logFile = logFiles.getLogFile();
        TransactionLogWriter transactionLogWriter = logFile.getTransactionLogWriter();
        CompleteCommandBatch emptyTx = TransactionLogInitializer.emptyTransaction(timestamp, upgradeTransactionId, kernelVersion, consensusIndex);
        int checksum = transactionLogWriter.append(emptyTx, upgradeTransactionId, 0L, appendIndex, -559063315, 0L, LogAppendEvent.NULL);
        logFile.forceAfterAppend((LogForceEvents)LogAppendEvent.NULL);
        LogPosition position = transactionLogWriter.getCurrentPosition();
        TransactionLogInitializer.appendCheckpoint(logFiles, reason, position, new TransactionId(upgradeTransactionId, appendIndex, kernelVersion, checksum, timestamp, consensusIndex), appendIndex, kernelVersion);
        this.logMetadataProvider.transactionCommitted(upgradeTransactionId, appendIndex, kernelVersion, checksum, timestamp, consensusIndex);
        return upgradeTransactionId;
    }

    private static CompleteCommandBatch emptyTransaction(long timestamp, long txId, KernelVersion kernelVersion, long consensusIndex) {
        return new CompleteCommandBatch(Collections.emptyList(), consensusIndex, timestamp, txId, timestamp, -1, Leases.NO_LEASES, kernelVersion, Subject.ANONYMOUS);
    }

    private static void appendCheckpoint(LogFiles logFiles, String reason, LogPosition position, TransactionId transactionId, long appendIndex, KernelVersion version) throws IOException {
        CheckpointAppender checkpointAppender = logFiles.getCheckpointFile().getCheckpointAppender();
        checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, appendIndex, version, position, position, Instant.now(), reason);
    }
}

