/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.files.LastClosedPositionProvider;
import org.neo4j.kernel.impl.transaction.log.files.LastCommittedChecksumProvider;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesOverrides;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.LogVersionRepository;

public class TransactionLogFilesProviders {
    private final LogMetadataProvider logMetadataProvider;
    private final TransactionLogFilesOverrides overrides;
    private final AppendIndexProvider lastAppendIndexProvider;
    private final LastCommittedChecksumProvider lastCommittedChecksumProvider;
    private final LogVersionRepository logVersionRepository;
    private final LastClosedPositionProvider lastClosedPositionProvider;

    public TransactionLogFilesProviders(LogMetadataProvider logMetadataProvider, TransactionLogFilesOverrides overrides) {
        this.logMetadataProvider = logMetadataProvider;
        this.overrides = overrides;
        this.logVersionRepository = this.setupLogVersionRepository();
        this.lastAppendIndexProvider = this.lastAppendIndexProvider();
        this.lastClosedPositionProvider = this.closePositionProvider();
        this.lastCommittedChecksumProvider = this.lastCommittedChecksumProvider();
    }

    private LastCommittedChecksumProvider lastCommittedChecksumProvider() {
        if (this.overrides.lastCommittedChecksumProvider() != null) {
            return () -> this.overrides.lastCommittedChecksumProvider().getAsInt();
        }
        if (this.overrides.transactionIdStore() != null) {
            return () -> this.overrides.transactionIdStore().getLastCommittedTransaction().checksum();
        }
        return () -> this.logMetadataProvider.getLastCommittedTransaction().checksum();
    }

    private LogVersionRepository setupLogVersionRepository() {
        if (this.overrides.logVersionRepository() != null) {
            return this.overrides.logVersionRepository();
        }
        return this.logMetadataProvider;
    }

    public LogVersionRepository getLogVersionRepository() {
        return this.logVersionRepository;
    }

    public long appendIndex() {
        return this.lastAppendIndexProvider.getLastAppendIndex();
    }

    LastClosedPositionProvider getLastClosedTransactionPositionProvider() {
        return this.lastClosedPositionProvider;
    }

    public LastCommittedChecksumProvider getLastCommittedChecksumProvider() {
        return this.lastCommittedChecksumProvider;
    }

    public KernelVersionProvider getKernelVersionProvider() {
        if (this.overrides.kernelVersionProvider() != null) {
            return this.overrides.kernelVersionProvider();
        }
        return this.logMetadataProvider;
    }

    public LogFormatVersionProvider getLogFormatVersionProvider() {
        if (this.overrides.logFormatVersionProvider() != null) {
            return this.overrides.logFormatVersionProvider();
        }
        return this.logMetadataProvider;
    }

    private AppendIndexProvider lastAppendIndexProvider() {
        if (this.overrides.appendIndexProvider() != null) {
            return this.overrides.appendIndexProvider();
        }
        return this.logMetadataProvider;
    }

    private LastClosedPositionProvider closePositionProvider() {
        if (this.overrides.transactionIdStore() != null) {
            return () -> this.overrides.transactionIdStore().getLastClosedTransaction().logPosition();
        }
        return () -> this.logMetadataProvider.getLastClosedTransaction().logPosition();
    }
}

