/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesOverrides;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesProviders;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogFile;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.LogMetadataProviderImpl;

public class TransactionLogFiles
extends LifecycleAdapter
implements LogFiles {
    public static final DirectoryStream.Filter<Path> DEFAULT_FILENAME_FILTER = TransactionLogFilesHelper.DEFAULT_FILENAME_FILTER;
    private final CheckpointFile checkpointLogFile;
    private final TransactionLogFilesOverrides overrides;
    private final TransactionLogFile logFile;
    private final Path logsDirectory;
    private volatile LogMetadataProviderImpl logMetadataProvider;
    private LifeSupport logFilesLife;

    TransactionLogFiles(Path logsDirectory, TransactionLogFilesContext context, TransactionLogFilesOverrides overrides) {
        this.logsDirectory = logsDirectory;
        this.logFile = new TransactionLogFile(this, context);
        this.checkpointLogFile = new CheckpointLogFile(this, context, overrides.externalLogTail());
        this.overrides = overrides;
        if (!overrides.noInit()) {
            LogTailMetadata tailMetadata = this.checkpointLogFile.getTailMetadata();
            this.logMetadataProvider = new LogMetadataProviderImpl(tailMetadata);
            TransactionLogFilesProviders transactionLogFilesProviders = new TransactionLogFilesProviders((LogMetadataProvider)this.logMetadataProvider, this.overrides);
            this.checkpointLogFile.initialize(transactionLogFilesProviders);
            this.logFile.initialize(transactionLogFilesProviders);
        }
    }

    @Override
    public LogMetadataProvider logMetadataProvider() {
        if (this.logMetadataProvider == null) {
            throw new IllegalStateException("Current version of log files can't perform any operation that require availability of LogMetadataProvider. Please build full version of log files to be able to use them.");
        }
        return this.logMetadataProvider;
    }

    public void init() throws IOException {
        if (this.overrides.noInit() || this.overrides.notStartable()) {
            throw new RuntimeException("Current version of log files can't be started. Please build full version of log files to be able to start them.");
        }
        this.logFilesLife = new LifeSupport();
        this.logFilesLife.add((Lifecycle)this.logFile);
        this.logFilesLife.add((Lifecycle)this.checkpointLogFile);
        this.logFilesLife.init();
    }

    public void start() throws IOException {
        this.logFilesLife.start();
    }

    public void stop() throws IOException {
        this.logFilesLife.stop();
    }

    public void shutdown() {
        this.logFilesLife.shutdown();
    }

    @Override
    public Path[] logFiles() throws IOException {
        return (Path[])ArrayUtil.concat((Object[])this.logFile.getMatchedFiles(), (Object[])this.checkpointLogFile.getMatchedFiles());
    }

    @Override
    public boolean isLogFile(Path path) {
        try {
            return DEFAULT_FILENAME_FILTER.accept(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public LogTailMetadata getTailMetadata() {
        return this.checkpointLogFile.getTailMetadata();
    }

    @Override
    public Path logFilesDirectory() {
        return this.logsDirectory;
    }

    @Override
    public LogFile getLogFile() {
        return this.logFile;
    }

    @Override
    public CheckpointFile getCheckpointFile() {
        return this.checkpointLogFile;
    }
}

