/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.entry.LogSegments;
import org.neo4j.kernel.impl.transaction.log.files.LogFileVersionTracker;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesOverrides;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.AppendIndexProvider;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;

public class LogFilesBuilder {
    private StorageEngineFactory storageEngineFactory;
    private CommandReaderFactory commandReaderFactory;
    private DatabaseLayout databaseLayout;
    private Path logsDirectory;
    private Config config;
    private Long rotationThreshold;
    private InternalLogProvider logProvider = NullLogProvider.getInstance();
    private DependencyResolver dependencies;
    private FileSystemAbstraction fileSystem;
    private LogVersionRepository logVersionRepository;
    private LogFileVersionTracker logFileVersionTracker;
    private TransactionIdStore transactionIdStore;
    private AppendIndexProvider appendIndexProvider;
    private IntSupplier lastCommittedChecksumProvider;
    private boolean fileBasedOperationsOnly;
    private DatabaseTracers databaseTracers = DatabaseTracers.EMPTY;
    private MemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
    private DatabaseHealth databaseHealth;
    private Clock clock;
    private Monitors monitors;
    private StoreId storeId;
    private KernelVersionProvider emptyLogskernelVersionProvider = KernelVersionProvider.THROWING_PROVIDER;
    private KernelVersionProvider kernelVersionProvider = null;
    private LogFormatVersionProvider emptyLogsLogFormatProvider = LogFormatVersionProvider.THROWING_PROVIDER;
    private LogFormatVersionProvider logFormatVersionProvider = null;
    private LogTailMetadata externalLogTail;
    private int envelopeSegmentBlockSizeBytes = LogSegments.DEFAULT_LOG_SEGMENT_SIZE;
    private int bufferSizeBytes;
    private boolean readOnlyLogs;
    private boolean noInit;
    private boolean turnOffPreallocation;

    private LogFilesBuilder() {
    }

    public static LogFilesBuilder writeableBuilder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, KernelVersionProvider emptyLogsKernelVersionProvider, LogFormatVersionProvider emptyLogsLogFormatVersionProvider) {
        LogFilesBuilder filesBuilder = new LogFilesBuilder();
        filesBuilder.databaseLayout = databaseLayout;
        filesBuilder.fileSystem = fileSystem;
        filesBuilder.emptyLogskernelVersionProvider = emptyLogsKernelVersionProvider;
        filesBuilder.emptyLogsLogFormatProvider = emptyLogsLogFormatVersionProvider;
        return filesBuilder;
    }

    public static LogFilesBuilder readableBuilder(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, KernelVersionProvider emptyLogsKernelVersionProvider, LogFormatVersionProvider emptyLogsLogFormatVersionProvider) {
        LogFilesBuilder builder = LogFilesBuilder.writeableBuilder(databaseLayout, fileSystem, emptyLogsKernelVersionProvider, emptyLogsLogFormatVersionProvider);
        builder.turnOffPreallocation = true;
        builder.readOnlyLogs = true;
        builder.noInit = true;
        return builder;
    }

    public static LogFilesBuilder logFilesBasedOnlyBuilder(Path logsDirectory, FileSystemAbstraction fileSystem) {
        LogFilesBuilder builder = new LogFilesBuilder();
        builder.logsDirectory = logsDirectory;
        builder.databaseLayout = DatabaseLayout.ofFlat((Path)logsDirectory);
        builder.fileSystem = fileSystem;
        builder.fileBasedOperationsOnly = true;
        builder.readOnlyLogs = true;
        builder.turnOffPreallocation = true;
        builder.noInit = true;
        return builder;
    }

    public LogFilesBuilder withLogVersionRepository(LogVersionRepository logVersionRepository) {
        this.logVersionRepository = logVersionRepository;
        return this;
    }

    public LogFilesBuilder withLogFileVersionTracker(LogFileVersionTracker logFileVersionTracker) {
        this.logFileVersionTracker = logFileVersionTracker;
        return this;
    }

    public LogFilesBuilder withTransactionIdStore(TransactionIdStore transactionIdStore) {
        this.transactionIdStore = transactionIdStore;
        return this;
    }

    public LogFilesBuilder withExternalLogTailMetadata(LogTailMetadata logTailMetadata) {
        this.externalLogTail = logTailMetadata;
        return this;
    }

    public LogFilesBuilder withLogProvider(InternalLogProvider logProvider) {
        this.logProvider = logProvider;
        return this;
    }

    public LogFilesBuilder withLastCommittedChecksumProvider(IntSupplier checksumProvider) {
        this.lastCommittedChecksumProvider = checksumProvider;
        return this;
    }

    public LogFilesBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public LogFilesBuilder withMonitors(Monitors monitors) {
        this.monitors = monitors;
        return this;
    }

    public LogFilesBuilder withRotationThreshold(long rotationThreshold) {
        this.rotationThreshold = rotationThreshold;
        return this;
    }

    public LogFilesBuilder withDependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public LogFilesBuilder withDatabaseTracers(DatabaseTracers databaseTracers) {
        this.databaseTracers = databaseTracers;
        return this;
    }

    public LogFilesBuilder withMemoryTracker(MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        return this;
    }

    public LogFilesBuilder withStoreId(StoreId storeId) {
        this.storeId = storeId;
        return this;
    }

    public LogFilesBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public LogFilesBuilder withDatabaseHealth(DatabaseHealth databaseHealth) {
        this.databaseHealth = databaseHealth;
        return this;
    }

    public LogFilesBuilder withStorageEngineFactory(StorageEngineFactory storageEngineFactory) {
        this.storageEngineFactory = storageEngineFactory;
        return this;
    }

    public LogFilesBuilder withCommandReaderFactory(CommandReaderFactory commandReaderFactory) {
        this.commandReaderFactory = commandReaderFactory;
        return this;
    }

    public LogFilesBuilder withAppendIndexProvider(AppendIndexProvider appendIndexProvider) {
        this.appendIndexProvider = appendIndexProvider;
        return this;
    }

    public LogFilesBuilder withLogsDirectory(Path logsDirectory) {
        this.logsDirectory = logsDirectory;
        return this;
    }

    public LogFilesBuilder withEnvelopeSegmentBlockSizeBytes(int envelopeSegmentBlockSizeBytes) {
        this.envelopeSegmentBlockSizeBytes = envelopeSegmentBlockSizeBytes;
        return this;
    }

    public LogFilesBuilder withBufferSizeBytes(int overrideBufferSizeBytes) {
        this.bufferSizeBytes = overrideBufferSizeBytes;
        return this;
    }

    public LogFilesBuilder withKernelVersionProvider(KernelVersionProvider kernelVersionProvider) {
        this.kernelVersionProvider = kernelVersionProvider;
        return this;
    }

    public LogFilesBuilder withLogFormatVersionProvider(LogFormatVersionProvider logFormatVersionProvider) {
        this.logFormatVersionProvider = logFormatVersionProvider;
        return this;
    }

    public LogFilesBuilder withInitializeProviders() {
        this.noInit = false;
        return this;
    }

    public LogFilesBuilder withNoInit() {
        this.noInit = true;
        return this;
    }

    public LogFilesBuilder withNoPreallocation() {
        this.turnOffPreallocation = true;
        return this;
    }

    public LogFiles build() throws IOException {
        TransactionLogFilesContext filesContext = this.buildContext();
        TransactionLogFilesOverrides overrides = this.buildOverrides();
        Path logsDirectory = this.getLogsDirectory();
        filesContext.getFileSystem().mkdirs(logsDirectory);
        return new TransactionLogFiles(logsDirectory, filesContext, overrides);
    }

    private Path getLogsDirectory() {
        return Objects.requireNonNullElseGet(this.logsDirectory, () -> this.databaseLayout.getTransactionLogsDirectory());
    }

    TransactionLogFilesOverrides buildOverrides() {
        return new TransactionLogFilesOverrides(this.logVersionRepository, this.transactionIdStore, this.appendIndexProvider, this.lastCommittedChecksumProvider, this.databaseLayout, this.logFormatVersionProvider, this.kernelVersionProvider, this.externalLogTail, this.noInit, this.noInit || this.fileBasedOperationsOnly || this.readOnlyLogs);
    }

    TransactionLogFilesContext buildContext() {
        if (this.config == null) {
            this.config = Config.defaults();
        }
        Objects.requireNonNull(this.fileSystem);
        Supplier<StoreId> storeIdSupplier = this.getStoreId();
        LogFileVersionTracker versionTracker = this.getLogFileVersionTracker();
        AtomicLong rotationThreshold = this.getRotationThresholdAndRegisterForUpdates();
        long checkpointThreshold = this.getCheckpointRotationThreshold();
        AtomicBoolean tryPreallocateTransactionLogs = this.getTryToPreallocateTransactionLogs();
        NativeAccess nativeAccess = this.getNativeAccess();
        Monitors monitors = this.getMonitors();
        DatabaseHealth health = this.getDatabaseHealth();
        Clock clock = this.getClock();
        return new TransactionLogFilesContext(rotationThreshold, checkpointThreshold, tryPreallocateTransactionLogs, this.commandReaderFactory(), versionTracker, this.fileSystem, this.logProvider, this.databaseTracers, storeIdSupplier, nativeAccess, this.memoryTracker, monitors, (Boolean)this.config.get(GraphDatabaseInternalSettings.fail_on_corrupted_log_files), health, this.emptyLogskernelVersionProvider, this.emptyLogsLogFormatProvider, clock, this.databaseLayout.getDatabaseName(), this.config, new BinarySupportedKernelVersions(this.config), this.readOnlyLogs, this.envelopeSegmentBlockSizeBytes, this.getBufferSizeBytes());
    }

    private CommandReaderFactory commandReaderFactory() {
        if (this.commandReaderFactory != null) {
            return this.commandReaderFactory;
        }
        if (this.fileBasedOperationsOnly) {
            return CommandReaderFactory.NO_COMMANDS;
        }
        return this.storageEngineFactory().commandReaderFactory();
    }

    private StorageEngineFactory storageEngineFactory() {
        if (this.storageEngineFactory == null) {
            this.storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fileSystem, (DatabaseLayout)this.databaseLayout).orElseThrow();
        }
        return this.storageEngineFactory;
    }

    private Clock getClock() {
        if (this.clock != null) {
            return this.clock;
        }
        return Clock.systemUTC();
    }

    private DatabaseHealth getDatabaseHealth() {
        if (this.databaseHealth != null) {
            return this.databaseHealth;
        }
        if (this.dependencies == null) {
            return new DatabaseHealth(HealthEventGenerator.NO_OP, this.logProvider.getLog(DatabaseHealth.class));
        }
        return this.dependencies.resolveOptionalDependency(DatabaseHealth.class).orElse(new DatabaseHealth(HealthEventGenerator.NO_OP, this.logProvider.getLog(DatabaseHealth.class)));
    }

    private Monitors getMonitors() {
        if (this.monitors == null) {
            return new Monitors();
        }
        return this.monitors;
    }

    private NativeAccess getNativeAccess() {
        if (this.dependencies == null) {
            return NativeAccessProvider.getNativeAccess();
        }
        return this.dependencies.resolveOptionalDependency(NativeAccess.class).orElseGet(NativeAccessProvider::getNativeAccess);
    }

    private int getBufferSizeBytes() {
        if (this.bufferSizeBytes == 0) {
            return (int)this.roundUpToEnvelopeSegment((Long)this.config.get(GraphDatabaseSettings.transaction_log_buffer_size));
        }
        return (int)this.roundUpToEnvelopeSegment(this.bufferSizeBytes);
    }

    private AtomicLong getRotationThresholdAndRegisterForUpdates() {
        if (this.rotationThreshold != null) {
            return new AtomicLong(this.guaranteeAtLeastTwoSegments(this.roundUpToEnvelopeSegment(this.rotationThreshold)));
        }
        AtomicLong configThreshold = new AtomicLong(this.guaranteeAtLeastTwoSegments(this.roundUpToEnvelopeSegment((Long)this.config.get(GraphDatabaseSettings.logical_log_rotation_threshold))));
        this.config.addListener(GraphDatabaseSettings.logical_log_rotation_threshold, (prev, update) -> configThreshold.set(this.guaranteeAtLeastTwoSegments(this.roundUpToEnvelopeSegment((long)update))));
        return configThreshold;
    }

    private long getCheckpointRotationThreshold() {
        return this.guaranteeAtLeastTwoSegments(this.roundUpToEnvelopeSegment((Long)this.config.get(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold)));
    }

    private long roundUpToEnvelopeSegment(long bytes) {
        return MathUtil.roundUp((long)bytes, (long)this.envelopeSegmentBlockSizeBytes);
    }

    private long guaranteeAtLeastTwoSegments(long rotationThreshold) {
        return Math.max(rotationThreshold, (long)this.envelopeSegmentBlockSizeBytes * 2L);
    }

    private AtomicBoolean getTryToPreallocateTransactionLogs() {
        if (this.turnOffPreallocation) {
            return new AtomicBoolean(false);
        }
        AtomicBoolean tryToPreallocate = new AtomicBoolean((Boolean)this.config.get(GraphDatabaseSettings.preallocate_logical_logs));
        this.config.addListener(GraphDatabaseSettings.preallocate_logical_logs, (prev, update) -> {
            String logMessage = "Updating " + GraphDatabaseSettings.preallocate_logical_logs.name() + " from " + prev + " to " + update;
            this.logProvider.getLog(LogFiles.class).debug(logMessage);
            tryToPreallocate.set((boolean)update);
        });
        return tryToPreallocate;
    }

    private LogFileVersionTracker getLogFileVersionTracker() {
        if (this.logFileVersionTracker != null) {
            return this.logFileVersionTracker;
        }
        if (this.dependencies == null) {
            return LogFileVersionTracker.NO_OP;
        }
        return this.dependencies.resolveOptionalDependency(LogFileVersionTracker.class).orElse(LogFileVersionTracker.NO_OP);
    }

    private Supplier<StoreId> getStoreId() {
        if (this.storeId != null) {
            return () -> this.storeId;
        }
        if (this.fileBasedOperationsOnly) {
            return () -> {
                throw new UnsupportedOperationException("Current version of log files can't perform any operation that require availability of store id. Please build full version of log files to be able to use them.");
            };
        }
        return () -> this.resolveDependency(StoreIdProvider.class).getStoreId();
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.dependencies.resolveDependency(clazz);
    }
}

